float  gTotalTime = 0.0;
float  gTimeStep  = 0.2;

float  FLIGHT_TIME = 10.0;
float  THRUST = 60000; 

integer  count = 0;
integer  countTimes = 5;
integer  countDown  = TRUE;



launch()
{
    gTotalTime = 0.0;
    llSetStatus(STATUS_PHYSICS, TRUE);
    llMessageLinked(LINK_ALL_CHILDREN, 3, "JETON", "");
    llSetForce(<0,0,THRUST>*llGetRot(), FALSE);
    llSetTimerEvent(gTimeStep);
}
 
  

   
default
{  
    state_entry()
    {  
        llSetStatus(STATUS_PHYSICS, FALSE);        
    }  

        
    touch_start(integer num)
    {
        llSetTimerEvent(1.0);
    }


    on_rez(integer num)
    {
        llSetTimerEvent(1.0);
    }
    
                                
    timer()
    {
        if (countDown) {
            if (count==countTimes) {
                llShout(0, "Fire!!");
                countDown = FALSE;
                launch();
            }
            else {
                llShout(0, (string)(countTimes-count));
                count++;
            }
            return;
        }
        
        gTotalTime += gTimeStep;
        if (gTotalTime < FLIGHT_TIME)
        {
            llSetForce(<0,0,THRUST>*llGetRot(), FALSE);
        }
        else
        {
            llSetStatus(STATUS_PHYSICS, FALSE);
            llMessageLinked(LINK_ALL_CHILDREN, 3, "JETOFF", "");
            llSetForce(<0,0,0>, TRUE);
            //llMakeExplosion(20, 1.0, 5, 3.0, 1.0, "green", ZERO_VECTOR);
            //llMakeExplosion(20, 1.0, 5, 3.0, 1.0, "blue", ZERO_VECTOR);
            llDie();
        }       
    }

    
    collision_start(integer num)
    {
        llSetStatus(STATUS_PHYSICS, FALSE);
        llMessageLinked(LINK_ALL_CHILDREN, 3, "JETOFF", "");
        llSetForce(<0,0,0>, TRUE);
        //llMakeExplosion(20, 1.0, 5, 3.0, 1.0, "green", ZERO_VECTOR);
        //llMakeExplosion(20, 1.0, 5, 3.0, 1.0, "blue", ZERO_VECTOR);
        llDie();
    }
}