///////////////////////////////////////////////////////////////////////////
//
//
//

integer dat_channel = 848;
integer drv_channel = 846;

integer listen_dat = 0;
integer listen_drv = 0;
integer i;


float   speed = 1.2;

vector  prev_point = <0.0, 0.0, 0.0>;
vector  next_point = <0.0, 0.0, 0.0>;

vector  cpoffset   = <-1.0, 0.0, 0.0>;

 

init_lsl()
{
    if (listen_dat!=0) llListenRemove(listen_dat);
    listen_dat = llListen(dat_channel, "", "", "");
    if (listen_dat<0) {
        llShout(0, "ERROR: LISTEN CHANNEL is "+(string)listen_dat);
    }
    
    prev_point = <0.0, 0.0, 0.0>;    
    next_point = <0.0, 0.0, 0.0>;
}

 
 

//
fllow_train(string recv_mesg)
{
    integer indx = llSubStringIndex(recv_mesg, ":");
    if (indx<0) return;
    vector recv_point = (vector)llGetSubString(recv_mesg, 0, indx-1) + cpoffset;
    
    if (recv_point!=next_point && recv_point!=prev_point) {
        prev_point = next_point;
        next_point = recv_point;
    
        vector   pos  = llGetPos();
        vector   dist = next_point - pos;
        vector   dtv  = llVecNorm(dist)*speed;
        integer  nn   = (integer)(llVecMag(dist)/speed) + 1;
    
        for (i=0; i<nn; i++) {
            pos  = llGetPos();
            dist = next_point - pos;
            rotation grt = llGetRot();
            //vector srce = <0,0,1>*grt;
            //vector ndst = srce + (dist - srce)/(nn-i);
            
            rotation rot = grt*llRotBetween(<0,0,1>*grt, dist);
            //rotation rot = grt*llRotBetween(<0,0,1>*grt, ndst);
            llSetPrimitiveParams([PRIM_POSITION, pos+dtv, PRIM_ROTATION, rot]);
        }
    }
}





default
{
    state_entry()
    {
        if (listen_drv!=0) llListenRemove(listen_drv);
        listen_drv = llListen(drv_channel, "", "", "");
        if (listen_drv<0) {
            llShout(0, "ERROR: LISTEN CHANNEL is "+(string)listen_drv);
        }
    }    
    

    on_rez(integer start_param)
    {
        llResetScript();
    }
    
    
    
    touch_start(integer total_number)
    {
    }

    
    
    listen(integer ch, string name, key id, string mesg) 
    {
        //llSay(0, "LISTEN: "+(string)ch+" "+name+" "+mesg);
        
        if (ch==dat_channel) {
            //if (listen_dat!=0) {
            //    llListenRemove(listen_dat);
            //    listen_dat = 0;
            //}
        
            list items = llParseString2List(mesg, ["=", " ", "\n"], []);
            string cmd = llList2String(items, 0);
        
            if (cmd=="DATA") {
                string point_mesg = llList2String(items, 1);
                fllow_train(point_mesg);
            }
            
            //if (listen_dat!=0) llListenRemove(listen_dat);
            //listen_dat = llListen(dat_channel, "", "", "");
            //if (listen_dat<0) {
            //    llShout(0, "ERROR: LISTEN CHANNEL is "+(string)listen_dat);
            //}

        }
        
        else if (ch==drv_channel) {
            //if (listen_drv!=0) {
            //    llListenRemove(listen_drv);
            //    listen_dat = 0;
            //}
            
            list items = llParseString2List(mesg, ["=", " ", "\n"], []);
            string cmd = llList2String(items, 0);
            
            if (llToLower(cmd)=="start") {
                llMessageLinked(LINK_THIS, 2, "START", "");
                llShout(0, "DRIVER START");
                init_lsl();
            }
                
            else if (llToLower(cmd)=="stop") {
                llMessageLinked(LINK_THIS, 2, "STOP", "");
                llShout(0, "DRIVER STOP");
                if (listen_dat!=0) {
                    llListenRemove(listen_dat);
                    listen_dat = 0;
                }
                llResetScript();
            }
            
            //if (listen_drv!=0) llListenRemove(listen_drv);
            //listen_drv = llListen(drv_channel, "", "", "");
            //if (listen_drv<0) {
            //    llShout(0, "ERROR: LISTEN CHANNEL is "+(string)listen_drv);
           // }
            
        }        
    }    

}