

integer cmd_channel = 855;
integer listen_hdl  = 0;

float   maxHeight;
float   maxSpeed;
float   stallSpeed;

float   speed  = 0.0;
float   height = 0.0;

integer status = 0;
integer pre_status = 0;
integer tmp_status = 0; 

integer over_height = TRUE;
integer over_speed  = TRUE;
integer stall_speed = FALSE;
integer nrmal_speed = FALSE;

string  nrm_color;
string  red_color;
string  ylw_color;
string  org_color;

integer pre_height3;
integer pre_height2;
integer pre_height1;

integer pre_speed3;
integer pre_speed2;
integer pre_speed1;

key     owner_id;
integer primid;



init_lsl()
{
    pre_speed1  = -1;
    pre_speed2  = -1;
    pre_speed3  = -1;
    pre_height1 = -1;
    pre_height2 = -1;
    pre_height3 = -1;
    
    over_height = TRUE;
    over_speed  = TRUE;
    stall_speed = FALSE;
    nrmal_speed = FALSE;
    
    primid = 1; 
    height = 0.0;
    speed  = 0.0;
    maxHeight = 0.0;
    maxSpeed  = 0.0;
    
    nrm_color = "0.2, 0.5, 0.5";
    ylw_color = "0.6, 0.6, 0.0";
    red_color = "0.9, 0.1, 0.1";
    org_color = "0.8, 0.4, 0.0";

    speed_color (nrm_color);   
    height_color(nrm_color);   
    height_display(0.0);
    speed_display(0.0);
    
    llSetTimerEvent(0);
        
    owner_id = llGetOwner();
    if (listen_hdl!=0) llListenRemove(listen_hdl);
    listen_hdl = llListen(cmd_channel, "", NULL_KEY, "");
    if (listen_hdl<=0) {
        llSay(0, "Listen Handle is "+(string)listen_hdl);
    }
}



speed_color(string color)
{
    llMessageLinked(primid+1, -1, color, "");    
    llMessageLinked(primid+2, -1, color, "");
    llMessageLinked(primid+3, -1, color, "");
}



height_color(string color)
{
    llMessageLinked(primid+4, -1, color, "");
    llMessageLinked(primid+5, -1, color, "");
    llMessageLinked(primid+6, -1, color, "");
}



speed_display(float speed)
{        
    integer s3 = ((integer)speed)/100;
    integer sp = ((integer)speed)%100;    
    integer s2 = sp/10;    
    integer s1 = sp%10;
    

    if (status==0) {
        if (((speed<maxSpeed&&speed>stallSpeed) || speed==0.0) && (!nrmal_speed||pre_status!=0)) {
            speed_color(nrm_color);   
            nrmal_speed = TRUE;
            stall_speed = FALSE;
            over_speed  = FALSE;
            pre_speed1  = -1;
            pre_speed2  = -1;
            pre_speed3  = -1;
        }
        else if (speed>=maxSpeed && (!over_speed||pre_status!=0)) {
            speed_color(ylw_color);
            nrmal_speed = FALSE;
            stall_speed = FALSE;
            over_speed  = TRUE;
            pre_speed1  = -1;
            pre_speed2  = -1;
            pre_speed3  = -1;
        }
        else if (speed<=stallSpeed && speed>0.0 && (!stall_speed||pre_status!=0)) {
            speed_color(red_color);   
            nrmal_speed = FALSE;
            stall_speed = TRUE;
            over_speed  = FALSE;
            pre_speed1  = -1;
            pre_speed2  = -1;
            pre_speed3  = -1;
        }
    }
    else {
        if (status==1)      speed_color(org_color);
        else if (status==2) speed_color(red_color);
        pre_speed1  = -1;
        pre_speed2  = -1;
        pre_speed3  = -1;
    }


    if (s3!=pre_speed3) {
        llMessageLinked(primid+1, s3, "", "");
        pre_speed3 = s3;
    }

    if (s2!=pre_speed2) {
        llMessageLinked(primid+2, s2, "", "");
        pre_speed2 = s2;
    }
    
    if (s1!=pre_speed1) {
        llMessageLinked(primid+3, s1, "", "");
        pre_speed1 = s1;
    }
}



height_display(float height)
{        
    integer h3 = ((integer)height)/100;
    integer ht = ((integer)height)%100;    
    integer h2 = ht/10;    
    integer h1 = ht%10;    

    if (status==0) {
        if (height>=maxHeight && (!over_height||pre_status!=0)) {
            height_color(red_color);
            over_height = TRUE;
            pre_height1 = -1;
            pre_height2 = -1;
            pre_height3 = -1;
        }
        else if (height<maxHeight && (over_height||pre_status!=0)) {
            height_color(nrm_color);   
            over_height = FALSE;
            pre_height1 = -1;
            pre_height2 = -1;
            pre_height3 = -1;
        }
    }
    else {
        if (status==1)      height_color(org_color);
        else if (status==2) height_color(red_color);
        pre_height1 = -1;
        pre_height2 = -1;
        pre_height3 = -1;
    }

                 
    if (h3!=pre_height3) {
        llMessageLinked(primid+4, h3, "", "");
        pre_height3 = h3;
    }

    if (h2!=pre_height2) {
        llMessageLinked(primid+5, h2, "", "");
        pre_height2 = h2;
    }
    
    if (h1!=pre_height1) {
        llMessageLinked(primid+6, h1, "", "");
        pre_height1 = h1;
    }
}




default
{
    state_entry()
    {
        init_lsl();
    }
    


    on_rez(integer param)
    {
        llResetScript();
    }
  


    timer()
    {
        pre_status = status;
        status = tmp_status;
        speed_display (speed); 
        height_display(height);         
    }



    listen(integer ch, string name, key id, string msg) 
    {
        list   items = llParseString2List(msg,[" "],[]);
        string cmd   = llList2String(items,0);
        string uid   = llList2String(items,1);
        
        //llShout(0,msg);
        if (uid==(string)owner_id) {
            if (cmd=="START") {
                init_lsl();
                maxSpeed   = (float)llList2String(items,2);
                stallSpeed = (float)llList2String(items,3);
                maxHeight  = (float)llList2String(items,4);
                llSetTimerEvent(1);
            }
            else if (cmd=="DATA") {
                speed  = (float)llList2String(items,2);
                height = (float)llList2String(items,3);
                tmp_status = (integer)llList2String(items,4);
            }
            else if (cmd=="STOP") {
                llSetTimerEvent(0);
            }
            else if (cmd=="RESET") {
                llSetTimerEvent(0);
                init_lsl();
            }
                        
        }
    }


} 