<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'ja', branch 'MOODLE_32_STABLE'
 *
 * @package   competency
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'すべての子が完了する';
$string['competencies'] = 'コンピテンシー';
$string['competenciesarenotenabled'] = 'コンピテンシーが有効にされていません。';
$string['competenciessettings'] = 'コンピテンシー設定';
$string['completeplanstask'] = '期限が到来している学習プランを完了する';
$string['coursecompetencyoutcome_complete'] = 'コンピテンシーを完了する';
$string['coursecompetencyoutcome_evidence'] = 'エビデンスを添付する';
$string['coursecompetencyoutcome_none'] = '何もしない';
$string['coursecompetencyoutcome_recommend'] = 'レビューのために送信する';
$string['coursemodulecompetencyoutcome_complete'] = 'コンピテンシーを完了する';
$string['coursemodulecompetencyoutcome_evidence'] = 'エビデンスを添付する';
$string['coursemodulecompetencyoutcome_none'] = '何もしない';
$string['coursemodulecompetencyoutcome_recommend'] = 'レビューのために送信する';
$string['deletecompetencyratings'] = 'コンピテンシー評定を削除する';
$string['duplicateditemname'] = '{$a} (コピー)';
$string['enablecompetencies'] = 'コンピテンシーを有効にする';
$string['enablecompetencies_desc'] = 'コンピテンシーにより、学習プランに従ってユーザを評価することができます。';
$string['errorcannotchangeapastduedate'] = '期限を経過しました。変更することはできません。';
$string['errorcannotsetduedateinthepast'] = '期限を過去に設定することはできません。';
$string['errorcannotsetduedatetoosoon'] = '期限が近すぎます。';
$string['errorcompetencyrule'] = '不明なコースコンピテンシールール「 {$a} 」です。';
$string['errorcoursecompetencyrule'] = '不明なコースコンピテンシールール「 {$a} 」です。';
$string['errorinvalidcourse'] = '無効なコースです。';
$string['errornocompetency'] = '{$a} コンピテンシーが見つかりませんでした。';
$string['errorplanstatus'] = '不明な学習プラン「 {$a} 」ステータスです。';
$string['errorscalealreadyused'] = 'すでに使用されているため、尺度を変更することはできません。';
$string['errorscaleconfiguration'] = 'あなたはデフォルトおよび熟達アイテムを選択することにより、尺度を設定する必要があります。';
$string['errorusercomptencystatus'] = '不明なユーザコンピテンシーステータス「 {$a} 」です。';
$string['eventcompetencycreated'] = 'コンピテンシーが作成されました。';
$string['eventcompetencydeleted'] = 'コンピテンシーが削除されました。';
$string['eventcompetencyframeworkcreated'] = 'コンピテンシーフレームワークが作成されました。';
$string['eventcompetencyframeworkdeleted'] = 'コンピテンシーフレームワークが削除されました。';
$string['eventcompetencyframeworkupdated'] = 'コンピテンシーフレームワークが更新されました。';
$string['eventcompetencyframeworkviewed'] = 'コンピテンシーフレームワークが閲覧されました。';
$string['eventcompetencyupdated'] = 'コンピテンシーが更新されました。';
$string['eventcompetencyviewed'] = 'コンピテンシーが閲覧されました。';
$string['eventevidencecreated'] = 'エビデンスが作成されました。';
$string['eventplanapproved'] = '学習プランが承認されました。';
$string['eventplancompleted'] = '学習プランが完了しました。';
$string['eventplancreated'] = '学習プランが作成されました。';
$string['eventplandeleted'] = '学習プランが削除されました。';
$string['eventplanreopened'] = '学習プランが再オープンされました。';
$string['eventplanreviewrequestcancelled'] = '学習プランレビューリクエストがキャンセルされました。';
$string['eventplanreviewrequested'] = '学習プランレビューがリクエストされました。';
$string['eventplanreviewstarted'] = '学習プランレビューが開始されました。';
$string['eventplanreviewstopped'] = '学習プランレビューが中断されました。';
$string['eventplanunapproved'] = '学習プランが承認されませんでした。';
$string['eventplanunlinked'] = '学習プランがリンク解除されました。';
$string['eventplanupdated'] = '学習プランが更新されました。';
$string['eventplanviewed'] = '学習プランが閲覧されました。';
$string['eventtemplatecreated'] = '学習プランテンプレートが作成されました。';
$string['eventtemplatedeleted'] = '学習プランテンプレートが削除されました。';
$string['eventtemplateupdated'] = '学習プランテンプレートが更新されました。';
$string['eventtemplateviewed'] = '学習プランテンプレートが閲覧されました。';
$string['eventusercompetencyplanviewed'] = 'ユーザコンピテンシープランが閲覧されました。';
$string['eventusercompetencyrated'] = 'ユーザコンピテンシーが評定されました。';
$string['eventusercompetencyratedincourse'] = 'ユーザコンピテンシーがコースで評定されました。';
$string['eventusercompetencyratedinplan'] = 'ユーザコンピテンシーが学習プランで評定されました。';
$string['eventusercompetencyreviewrequestcancelled'] = 'ユーザコンピテンシーレビューリクエストがキャンセルされました。';
$string['eventusercompetencyreviewrequested'] = 'ユーザコンピテンシーレビューがリクエストされました。';
$string['eventusercompetencyreviewstarted'] = 'ユーザコンピテンシーレビューが開始されました。';
$string['eventusercompetencyreviewstopped'] = 'ユーザコンピテンシーレビューが中断されました。';
$string['eventusercompetencyviewed'] = 'ユーザコンピテンシーが閲覧されました。';
$string['eventusercompetencyviewedincourse'] = 'ユーザコンピテンシーがコースで閲覧されました。';
$string['eventusercompetencyviewedinplan'] = 'ユーザコンピテンシーが学習プランで閲覧されました。';
$string['eventuserevidencecreated'] = '事前学習エビデンスが作成されました。';
$string['eventuserevidencedeleted'] = '事前学習エビデンスが削除されました。';
$string['eventuserevidenceupdated'] = '事前学習エビデンスが更新されました。';
$string['evidence_competencyrule'] = 'コンピテンシールールが合致しません。';
$string['evidence_coursecompleted'] = 'コース「 {$a} 」が完了しました。';
$string['evidence_coursemodulecompleted'] = '活動「 {$a} 」が完了しました。';
$string['evidence_courserestored'] = 'コース「 {$a} 」と共に評定がリストアされました。';
$string['evidence_evidenceofpriorlearninglinked'] = '事前学習エビデンス「 {$a} 」がリンクされました。';
$string['evidence_evidenceofpriorlearningunlinked'] = '事前学習エビデンス「 {$a} 」がリンク解除されました。';
$string['evidence_manualoverride'] = 'コンピテンシー評定は手動設定されました。';
$string['evidence_manualoverrideincourse'] = 'コンピテンシー評定はコース「 {$a} 」で手動設定されました。';
$string['evidence_manualoverrideinplan'] = 'コンピテンシー評定は学習プラン「 {$a} 」で手動設定されました。';
$string['invalidevidencedesc'] = '無効なエビデンス説明';
$string['invalidgrade'] = '無効な評定';
$string['invalidpersistent'] = '無効な持続性です。';
$string['invalidpersistenterror'] = 'エラー: {$a}';
$string['invalidplan'] = '無効な学習プラン';
$string['invalidtaxonomy'] = '無効な分類: {$a}';
$string['invalidurl'] = 'URLが有効ではありません。「http://」または「https://」で始まっていることを確認してください。';
$string['planstatusactive'] = 'アクティブ';
$string['planstatuscomplete'] = '完了';
$string['planstatusdraft'] = '下書き';
$string['planstatusinreview'] = 'レビュー中';
$string['planstatuswaitingforreview'] = 'レビュー待ち';
$string['pointsrequiredaremet'] = '必須評点に合致する';
$string['pushcourseratingstouserplans'] = 'コース評定を個別の学習プランに転送する';
$string['pushcourseratingstouserplans_desc'] = 'コースコンピテンシーの評定時に更新する個別の学習プランのためのコース設定デフォルト値です。';
$string['syncplanscohorts'] = '学習プランテンプレートコーホートからプランを同期する';
$string['taxonomy_behaviour'] = '行動';
$string['taxonomy_competency'] = 'コンピテンシー';
$string['taxonomy_concept'] = 'コンセプト';
$string['taxonomy_domain'] = 'ドメイン';
$string['taxonomy_indicator'] = '指標';
$string['taxonomy_level'] = 'レベル';
$string['taxonomy_outcome'] = 'アウトカム';
$string['taxonomy_practice'] = 'プラクティス';
$string['taxonomy_proficiency'] = '熟達';
$string['taxonomy_skill'] = 'スキル';
$string['taxonomy_value'] = '値';
$string['usercommentedonacompetency'] = '{$a->fullname} がコンピテンシー「 {$a->competency} 」にコメントしました:

{$a->comment}

詳細は次をご覧ください: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} がコンピテンシー「 {$a->competency} 」にコメントしました:</p>
<div>{$a->comment}</div>
<p>詳細は次をご覧ください: <a href="{$a->url}">{$a->urlname}</a></p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} がコンピテンシー「 {$a->competency} 」にコメントしました。';
$string['usercommentedonacompetencysubject'] = '{$a} がコンピテンシーにコメントしました。';
$string['usercommentedonaplan'] = '{$a->fullname} が学習プラン「 {$a->plan} 」にコメントしました:

{$a->comment}

詳細は次をご覧ください: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} が学習プラン「 {$a->plan} 」にコメントしました:</p>
<div>{$a->comment}</div>
<p>詳細は次をご覧ください: <a href="{$a->url}">{$a->urlname}</a></p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} が学習プラン「 {$a->plan} 」にコメントしました。';
$string['usercommentedonaplansubject'] = '{$a} が学習プランにコメントしました。';
$string['usercompetencystatus_idle'] = '待機';
$string['usercompetencystatus_inreview'] = 'レビュー中';
$string['usercompetencystatus_waitingforreview'] = 'レビュー待ち';
$string['userplans'] = '学習プラン';
