<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'ja', branch 'MOODLE_32_STABLE'
 *
 * @package   scheduler
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = '操作';
$string['actions'] = '操作';
$string['addappointment'] = 'もう1人の学生を追加する';
$string['addcommands'] = '時間帯を追加する';
$string['addondays'] = '予約を追加する';
$string['addsession'] = 'いくつかの時間帯を追加する';
$string['addsingleslot'] = '単一時間帯を追加する';
$string['addslot'] = 'あなたはいつでも予約時間帯を追加することができます。';
$string['addstudenttogroup'] = 'この学生を予約グループに追加する';
$string['allappointments'] = 'すべての予約';
$string['allononepage'] = 'すべての時間帯を1つのページに表示する';
$string['allowgroup'] = '排他的時間帯 - 変更するにはクリック';
$string['allteachersgrading'] = '教師はすべての予約を評定できる';
$string['alreadyappointed'] = 'すでに時間帯が予約で一杯のため、予約できません。';
$string['appointagroup_help'] = 'あなたのみ予約したいか、それともグループ全体で予約したいか選択してください。';
$string['appointingstudent'] = '時間帯の予約';
$string['appointingstudentinnew'] = '新しい時間帯の予約';
$string['appointment'] = '予約';
$string['appointmentmode'] = '予約モード設定';
$string['appointmentno'] = '予約 {$a}';
$string['appointments'] = '予約';
$string['appointsolo'] = '私のみ';
$string['appointsomeone'] = '新しい予約を追加する';
$string['attendable'] = '出席可能';
$string['attendablelbl'] = 'スケジューリングの候補者合計';
$string['attended'] = '出席済み';
$string['attendedlbl'] = '出席済み学生数';
$string['attendedslots'] = '参加済み時間帯';
$string['availableslots'] = '利用可能な時間帯';
$string['availableslotsall'] = 'すべての時間帯';
$string['availableslotsnotowned'] = '自分以外の時間帯';
$string['availableslotsowned'] = '自分の時間帯';
$string['bookslot'] = '予約';
$string['bookwithteacher'] = '教師';
$string['bookwithteacher_help'] = '予約の教師を選択してください。';
$string['break'] = '時間帯間の休憩時間';
$string['breaknotnegative'] = '休憩時間の長さはマイナスにすることができません。';
$string['canbook1appointment'] = 'あなたはこのスケジューラでさらに 1 件の時間帯を予約することができます。';
$string['canbooknappointments'] = 'あなたはこのスケジューラでさらに {$a} 件の時間帯を予約することができます。';
$string['canbooknofurtherappointments'] = 'あなたはこのスケジューラでこれ以上予約することはできません。';
$string['canbooksingleappointment'] = 'あなたはこのスケジューラで 1 件の時間帯を予約することができます。';
$string['canbookunlimitedappointments'] = 'あなたはこのスケジューラで何件でも時間帯を予約することができます。';
$string['cancelbooking'] = '予約をキャンセルする';
$string['chooseexisting'] = '既存の時間帯を選択する';
$string['choosingslotstart'] = '既存の開始時間の選択';
$string['comments'] = 'コメント';
$string['complete'] = '予約済';
$string['conflictingslots'] = '衝突';
$string['course'] = 'コース';
$string['csvfieldseparator'] = 'CSVフィールドセパレータ';
$string['date'] = '日付';
$string['datelist'] = '概要';
$string['defaultslotduration'] = 'デフォルトの時間帯継続時間';
$string['defaultslotduration_help'] = 'あなたが設定する予約時間帯のデフォルト長 (分) です。';
$string['deleteallslots'] = 'すべての時間帯を削除する';
$string['deleteallunusedslots'] = '未使用の時間帯すべてを削除する';
$string['deletemyslots'] = '私の時間帯すべてを削除する';
$string['deleteselection'] = '選択した時間帯を削除する';
$string['deletetheseslots'] = 'これらの時間帯を削除する';
$string['deleteunusedslots'] = '私の未使用時間帯を削除する';
$string['department'] = 'どこから?';
$string['disengage'] = '私の予約をキャンセルする';
$string['displayfrom'] = '学生に予約を表示する';
$string['distributetoslot'] = 'グループ全体に分配する';
$string['divide'] = '時間帯で分割しますか?';
$string['duration'] = '継続期間';
$string['durationrange'] = '時間帯継続時間は {$a->min} から {$a->max} 分の間に設定する必要があります。';
$string['email_applied_plain'] = 'コースの学生「 {$a->attendee} 」により、{$a->date} {$a->time} の予約が申請されました:

{$a->course_short}: {$a->course}

ウェブサイト「 {$a->site} 」のスケジューラ「 {$a->module} 」を使用しています。';
$string['email_applied_subject'] = '{$a->course_short}: 新しい予約';
$string['email_cancelled_plain'] = 'ウェブサイト「 {$a->site} 」のスケジューラ「 {$a->module} 」において、あなたのコース「 {$a->course_short}: {$a->course} 」の学生「 {$a->attendant} 」との {$a->date} {$a->time} の予約がキャンセルまたは移動されました。';
$string['email_cancelled_subject'] = '{$a->course_short}: 学生による予約のキャンセルまたは移動';
$string['emailreminder'] = 'リマインダをメール送信する';
$string['emailreminderondate'] = 'リマインダをメール送信する';
$string['email_reminder_plain'] = 'あなたには近日中の予約があります。
予約日時: {$a->date} {$a->time} - {$a->endtime}
参加者: {$a->attendant}.

ロケーション: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: 予約リマインダ';
$string['email_teachercancelled_plain'] = 'ウェブサイト「 {$a->site} 」のスケジューラ「 {$a->module} 」において、あなたのコース「 {$a->course_short}: {$a->course} 」の「 {$a->staffrole} {$a->attendant} 」との {$a->date} {$a->time} の予約がキャンセルされました。

新しい時間帯を申請してください。';
$string['email_teachercancelled_subject'] = '{$a->course_short}: 教師によりキャンセルされた予約';
$string['end'] = '終了';
$string['exclusive'] = '排他的';
$string['exclusivity'] = '排他性';
$string['exclusivity_help'] = '<p>あなたは時間帯に適用できる学生総数を設定することができます。</p>
<p>制限を「1」 (デフォルト) にした場合、時間帯は排他モードになります。</p>
<p>時間帯が無制限 (0) に設定された場合、同じ時間枠で他の時間帯が排他または制限設定されたとしても、この時間帯は制約評価とみなされません。
</p>';
$string['exclusivityoverload'] = '時間帯にはこの設定を超える {$a} 名の学生予約があります。';
$string['explaingeneralconfig'] = 'これらのオプションはサイトレベルでのみ設定することができます。また、このMoodleインストレーションのスケジューラすべてに適用されます。';
$string['finalgrade'] = '最終評点';
$string['forbidgroup'] = 'グループ時間帯 - 変更するにはクリック';
$string['forcewhenoverlap'] = '重複時に強制する';
$string['forcewhenoverlap_help'] = '<p>セッションが他の時間帯と衝突した場合、ここでは時間帯の追加強制をコントロールします。この場合、「クリーン」時間帯のみ追加されます。衝突は無視されます。</p>

<p>使用しない場合、重複検出時に追加処理はブロックされます。また、処理が新しい時間帯を追加できる前に、あなたには前の時間帯の削除が求められます。</p>';
$string['forcourses'] = 'コースの学生を選択する';
$string['friday'] = '金曜日';
$string['generalconfig'] = '一般設定';
$string['grade'] = '評点';
$string['gradingstrategy'] = '評定方法';
$string['gradingstrategy_help'] = 'スケジューラにおいて、学生が複数の予約を申請できる場合、評点の総計方法を選択してください。学生の評点が「評点平均」または「最高評点」であっても、評定表に表示することができます。';
$string['group'] = 'グループ';
$string['groupbreakdown'] = 'グループサイズ';
$string['groupscheduling'] = 'グループスケジューリングを有効にする';
$string['groupscheduling_desc'] = 'グループ全体を一度にスケジュールできるようにします (この機能を有効にするには、グローバルオプションは別として、活動グループモードを「可視グループ」または「分離グループ」に設定する必要があります)。';
$string['groupsession'] = 'グループセッション';
$string['groupsize'] = 'グループサイズ';
$string['guestscantdoanything'] = 'ゲストはここで何もできません。';
$string['howtoaddstudents'] = '学生をグローバルスコープのスケジューラに追加する場合、モジュールのロール設定を選択してください。<br　/>あなたの学生の世話役を定義する場合、モジュールロール定義を使用することもできます。';
$string['ignoreconflicts'] = 'スケジューリング衝突を無視する';
$string['ignoreconflicts_help'] = 'このチェックボックスをチェックした場合、他の時間帯が同一時間に存在したとしても、時間帯はリクエストされた日時に移動されます。これは教師または学生に対して、予約の重複を招く可能性があるため、注意して使用してください。';
$string['incourse'] = '- コース';
$string['introduction'] = '説明';
$string['isnonexclusive'] = '非排他的';
$string['lengthbreakdown'] = '時間帯継続時間';
$string['limited'] = '制限 (残り {$a})';
$string['location'] = 'ロケーション';
$string['location_help'] = '予約のロケーションを指定してください。';
$string['markasseennow'] = '「面会済み」にマークする';
$string['markseen'] = 'あなたが学生と面会した後、上記テーブル内の適切なチェックボックスをチェックして、「面会済み」にマークしてください。';
$string['maxgrade'] = '最高評点';
$string['maxstudentlistsize'] = '学生リストの最大長';
$string['maxstudentlistsize_desc'] = '予約する必要のある学生リストの最大長です。スケジューラの教師ビューに表示されます。この数より学生数が多い場合、リストは表示されません。';
$string['maxstudentsperslot'] = '時間帯あたりの最大学生数';
$string['maxstudentsperslot_desc'] = 'グループ時間帯 / 非排他的時間帯では、最大でこの数の学生を登録することができます。加えて、時間帯に対して常に設定「無制限」を選択できることに留意してください。';
$string['meangrade'] = '評点平均';
$string['meetingwith'] = '面会スケジュール:';
$string['meetingwithplural'] = '面会スケジュール:';
$string['minutes'] = '分';
$string['minutesperslot'] = '時間帯あたりの時間 (分)';
$string['missingstudents'] = '{$a} 名の学生が予約する必要があります。';
$string['missingstudentsmany'] = '{$a} 名の学生が予約する必要があります。サイズのため、リストは表示されません。';
$string['mode'] = 'モード';
$string['modulename'] = 'スケジューラ';
$string['modulenameplural'] = 'スケジューラ';
$string['monday'] = '月曜日';
$string['myappointments'] = '私の予約';
$string['name'] = 'スケジューラ名';
$string['needteachers'] = '教師が存在しないため、このコースに時間帯を追加することはできません。';
$string['negativerange'] = '範囲がマイナスです。これは受け入れられません。';
$string['never'] = 'なし';
$string['noappointments'] = '面会予約なし';
$string['noexistingstudents'] = '既存の学生なし';
$string['nogroups'] = 'スケジュール可能なグループはありません。';
$string['noresults'] = '結果なし';
$string['noschedulers'] = 'スケジューラはありません。';
$string['noslots'] = '利用できる予約時間帯はありません。';
$string['noslotsavailable'] = '現在、利用できる予約時間帯はありません。';
$string['noslotsopennow'] = '現在、開いている時間帯はありません。';
$string['nostudents'] = '予約している学生はいません。';
$string['nostudenttobook'] = '予約できる学生はいません。';
$string['note'] = '評点';
$string['noteacherforslot'] = '時間帯の教師はいません。';
$string['noteachershere'] = '利用可能な教師はいません。';
$string['notifications'] = '通知';
$string['notifications_help'] = 'このオプションを有効にした場合、教師および学生に対して、予約の申し込みまたはキャンセルが通知されます。';
$string['now'] = '今から';
$string['occurrences'] = '発生';
$string['on'] = '-';
$string['onedaybefore'] = '時間帯1日前';
$string['oneslotadded'] = '1つの時間帯が追加されました。';
$string['oneweekbefore'] = '時間帯1週間前';
$string['onthemorningofappointment'] = '予約日の朝';
$string['overall'] = '全体';
$string['overlappings'] = 'いくつかの他の時間帯が重複しています。';
$string['pluginadministration'] = 'スケジューラ管理';
$string['pluginname'] = 'スケジューラ';
$string['registeredlbl'] = '予約済み学生';
$string['reminder'] = 'リマインダ';
$string['resetappointments'] = '予約および評点を削除する';
$string['resetslots'] = '時間帯を削除する';
$string['return'] = 'コースに戻る';
$string['revoke'] = '予約を取り消す';
$string['saturday'] = '土曜日';
$string['save'] = '保存';
$string['savechoice'] = '私の選択を保存する';
$string['saveseen'] = '「面会済み」を保存する';
$string['schedule'] = 'スケジュール';
$string['scheduleappointment'] = '{$a} の予約スケジュール';
$string['schedulecancelled'] = '{$a} : あなたの予約はキャンセルまたは移動されました。';
$string['schedulegroups'] = 'グループごとのスケジュール';
$string['scheduleinnew'] = '新しい時間帯のスケジュール';
$string['scheduler'] = 'スケジューラ';
$string['scheduler:addinstance'] = '新しいスケジューラを追加する';
$string['scheduler:appoint'] = '予約する';
$string['scheduler:attend'] = '学生を世話する';
$string['scheduler:canscheduletootherteachers'] = '他のスタッフメンバーの予約を決定する';
$string['scheduler:canseeotherteachersbooking'] = '他の教師の予約を閲覧する';
$string['scheduler:disengage'] = 'このケイパビリティは廃止されたため、何も実行されません。';
$string['scheduler:manage'] = 'あなたの時間帯および予約を管理する';
$string['scheduler:manageallappointments'] = 'すべてのスケジューラデータを管理する';
$string['scheduler:seeotherstudentsbooking'] = 'この時間帯内の他の学生の予約を閲覧する';
$string['scheduler:seeotherstudentsresults'] = '他の時間帯内の学生の結果を閲覧する';
$string['schedulestudents'] = '学生ごとのスケジュール';
$string['seen'] = '面会済み';
$string['showemailplain'] = 'メールアドレスをプレインテキストに表示する';
$string['showemailplain_desc'] = 'スケジューラの教師ビューにおいて、mailto: リンクに加えて、予約が必要な学生のメールアドレスをプレインテキストで表示します。';
$string['slots'] = '時間帯';
$string['slotsadded'] = '{$a} 件の時間帯が追加されました。';
$string['slottype'] = '時間帯タイプ';
$string['slotupdated'] = '1 件の時間帯が更新されました。';
$string['staffbreakdown'] = '{$a}';
$string['staffrolename'] = '教師のロール名';
$string['staffrolename_help'] = '学生を世話するロールのラベルです。これは必ずしも「教師」である必要はありません。';
$string['start'] = '開始';
$string['statistics'] = '統計';
$string['student'] = '学生';
$string['studentbreakdown'] = '学生';
$string['studentcomments'] = '学生メモ';
$string['studentdetails'] = '学生詳細';
$string['studentmultiselect'] = 'それぞれの学生はこの時間帯で１回のみ選択することができます。';
$string['studentnotes'] = '予約に関するあなたのメモ';
$string['students'] = '学生';
$string['sunday'] = '日曜日';
$string['teacher'] = '教師';
$string['thursday'] = '木曜日';
$string['tuesday'] = '火曜日';
$string['unattended'] = '出席なし';
$string['unlimited'] = '無制限';
$string['unregisteredlbl'] = '予約未了の学生';
$string['upcomingslots'] = 'あなたの予約状況';
$string['updategrades'] = '評点を更新する';
$string['updatesingleslot'] = '&nbsp;';
$string['wednesday'] = '水曜日';
$string['welcomebackstudent'] = 'あなたは「予約」ボタンをクリックすることにより、さらに予約することができます。';
$string['welcomenewstudent'] = '下記テーブルには利用可能な時間帯すべてを表示しています。あなたは「予約」ボタンをクリックすることにより、予約することができます。あなたが後で予約を変更したい場合、このページに再度アクセスすることができます。';
$string['welcomenewteacher'] = 'あなたの学生すべてとの予約を追加するには、下のボタンをクリックしてください。';
$string['what'] = '何を?';
$string['whathappened'] = '何が起きた?';
$string['whatresulted'] = '結果は?';
$string['when'] = 'いつ?';
$string['where'] = 'どこで?';
$string['who'] = '誰と?';
$string['whosthere'] = '誰がそこにいましたか?';
$string['xdaysbefore'] = '時間帯まで {$a} 日';
$string['xweeksbefore'] = '時間帯まで {$a} 週間';
$string['yourappointmentnote'] = 'あなたの見解によるメモ';
$string['yourslotnotes'] = '面会のコメント';
