<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'ja', branch 'MOODLE_32_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'アクセスコントロール';
$string['actionaftercorrectanswer'] = '正解後のアクション';
$string['actionaftercorrectanswer_help'] = '問題に正しく答えた後、ページの移動には3つのオプションがあります:

*通常 - レッスンパスに従います。
*未閲覧のページを表示する - ページがランダムに表示されます。同一ページが2度表示されることはありません。
*未解答のページを表示する - ページがランダムに表示されます。未解答の問題を含むページは再度表示されます。';
$string['actions'] = 'アクション';
$string['activitylink'] = '次の活動にリンクする';
$string['activitylink_help'] = 'レッスンの最後にコース内の別の活動へのリンクを提供するにはドロップダウンメニューより活動を選択してください。';
$string['activitylinkname'] = '{$a} へ移動する';
$string['activityoverview'] = 'あなたには有効期限の到来したレッスンがあります。';
$string['addabranchtable'] = 'コンテンツページを追加する';
$string['addanendofbranch'] = '終了ブランチを追加する';
$string['addanewpage'] = '新しいページを追加する';
$string['addaquestionpage'] = '問題ページを追加する';
$string['addaquestionpagehere'] = '問題ページをここに追加する';
$string['addbranchtable'] = 'コンテンツページを追加する';
$string['addcluster'] = 'クラスタを追加する';
$string['addedabranchtable'] = 'コンテンツページが追加されました。';
$string['addedanendofbranch'] = '終了ブランチが追加されました。';
$string['addedaquestionpage'] = '問題ページが追加されました。';
$string['addedcluster'] = 'クラスタが追加されました。';
$string['addedendofcluster'] = '終了クラスタが追加されました。';
$string['addendofcluster'] = '終了クラスタを追加する';
$string['additionalattemptsremaining'] = '完了しました。あなたはこのレッスンを再受験することができます。';
$string['addnewgroupoverride'] = 'グループオーバーライドを追加する';
$string['addnewuseroverride'] = 'ユーザオーバーライドを追加する';
$string['addpage'] = 'ページを追加する';
$string['anchortitle'] = 'メインコンテンツの開始';
$string['and'] = 'AND';
$string['answer'] = '答え/選択肢';
$string['answeredcorrectly'] = '正しく解答されました。';
$string['answersfornumerical'] = '数値問題に対する解答は最大値および最小値の範囲内に入る必要があります。';
$string['arrangebuttonshorizontally'] = 'コンテンツボタンを水平に配置しますか?';
$string['attempt'] = '受験: {$a}';
$string['attemptheader'] = '受験';
$string['attempts'] = '受験';
$string['attemptsdeleted'] = '受験結果が削除されました。';
$string['attemptsremaining'] = 'あなたには {$a} 回の受験回数が残っています。';
$string['available'] = '開始日時';
$string['averagescore'] = '平均評点';
$string['averagetime'] = '平均時間';
$string['branch'] = 'コンテンツ';
$string['branchtable'] = 'コンテンツ';
$string['cancel'] = 'キャンセル';
$string['cannotfindanswer'] = 'エラー: 答えが見つかりませんでした。';
$string['cannotfindattempt'] = 'エラー: 受験が見つかりませんでした。';
$string['cannotfindessay'] = 'エラー: 作文が見つかりませんでした。';
$string['cannotfindfirstgrade'] = 'エラー: 評点が見つかりませんでした。';
$string['cannotfindfirstpage'] = '最初のページが見つかりませんでした。';
$string['cannotfindgrade'] = 'エラー: 評点が見つかりませんでした。';
$string['cannotfindnewestgrade'] = 'エラー: 最新の評点が見つかりませんでした。';
$string['cannotfindnextpage'] = 'レッスンバックアップ: 次のページが見つかりませんでした!';
$string['cannotfindpagerecord'] = '終了ブランチを追加する: ページレコードが見つかりませんでした。';
$string['cannotfindpages'] = 'レッスンページが見つかりませんでした。';
$string['cannotfindpagetitle'] = '削除の確認: ページタイトルが見つかりませんでした。';
$string['cannotfindpreattempt'] = '前回の受験レコードが見つかりませんでした!';
$string['cannotfindrecords'] = 'エラー: レッスンレコードが見つかりませんでした。';
$string['cannotfindtimer'] = 'エラー: lesson_timerレコードが見つかりませんでした。';
$string['cannotfinduser'] = 'エラー: ユーザが見つかりませんでした。';
$string['canretake'] = '{$a} の再受験を許可する';
$string['casesensitive'] = '正規表現を使用する';
$string['casesensitive_help'] = 'この設定を有効にした場合、解答の分析に正規表現を使用します。';
$string['checkbranchtable'] = 'コンテンツページを確認する';
$string['checkedthisone'] = 'チェックされました。';
$string['checknavigation'] = 'ナビゲーションを確認する';
$string['checkquestion'] = '問題を確認する';
$string['classstats'] = 'クラス統計';
$string['clicktodownload'] = 'ファイルをダウンロードするには次のリンクをクリックしてください。';
$string['clicktopost'] = 'あなたの評点をハイスコアリストに登録するにはここをクリックしてください。';
$string['closebeforeopen'] = 'レッスンを更新できませんでした。あなたは開始日時の前に終了日時を指定しました。';
$string['cluster'] = 'クラスタ';
$string['clusterjump'] = 'クラスタ内の未閲覧の問題';
$string['clustertitle'] = 'クラスタ';
$string['collapsed'] = '折りたたむ';
$string['comments'] = 'あなたのコメント';
$string['completed'] = '完了';
$string['completederror'] = 'レッスンを完了する';
$string['completethefollowingconditions'] = '先へ進むには<b>{$a}</b>レッスンの下記コンディションを完了させる必要があります。';
$string['completionendreached'] = '最終到達必須';
$string['completionendreached_desc'] = 'この活動を完了するには学生はレッスンの最終ページに到達する必要があります。';
$string['completiontimespent'] = '学生は少なくとも次の時間この活動を実施する必要があります:';
$string['completiontimespentgroup'] = '必要滞在時間';
$string['conditionsfordependency'] = '依存条件';
$string['configactionaftercorrectanswer'] = '正解後のデフォルトのアクションです。';
$string['configintro'] = 'ここでは新しいレッスンの作成時に設定フォーム内で使用されるデフォルト値を定義します。「高度」が指定された設定は「さらに表示する ...」リンクがクリックされた場合のみ表示されます。';
$string['configmaxanswers'] = 'ページごとの答えの最大数のデフォルトです。';
$string['configmaxhighscores'] = '表示されるハイスコア数です。';
$string['configmediaclose'] = 'リンクメディアファイルに生成されるポップアップの一部に「ウィンドウを閉じる」ボタンを表示します。';
$string['configmediaheight'] = 'リンクメディアファイルに表示されるポップアップの高さを設定します。';
$string['configmediawidth'] = 'リンクメディアファイルに表示されるポップアップの幅を設定します。';
$string['configpassword_desc'] = 'レッスンへのアクセスにパスワードを必要とするかどうか決定します。';
$string['configslideshowbgcolor'] = '有効にされた場合に使用されるスライドショーの背景色を設定します。';
$string['configslideshowheight'] = '有効にされた場合に使用されるスライドショーの高さを設定します。';
$string['configslideshowwidth'] = '有効にされた場合に使用されるスライドショーの幅を設定します。';
$string['configtimelimit_desc'] = '時間制限が設定された場合、レッスンの最初に警告およびカウントダウンタイマーが表示されます。ゼロに設定された場合、時間制限はありません。';
$string['confirmdelete'] = 'ページを削除する';
$string['confirmdeletionofthispage'] = '本当にこのページを削除してもよろしいですか?';
$string['congratulations'] = 'おめでとうございます - レッスンの最後に到達しました。';
$string['continue'] = '続ける';
$string['continuetoanswer'] = '続けて答えを変更します。';
$string['continuetonextpage'] = '続けて次のページに移動します。';
$string['correctanswerjump'] = '正解のジャンプ先';
$string['correctanswerscore'] = '正解の評点';
$string['correctresponse'] = '正解';
$string['createaquestionpage'] = '問題ページを作成する';
$string['credit'] = '承認';
$string['customscoring'] = 'カスタムスコア';
$string['customscoring_help'] = 'この設定を有効にした場合、それぞれの答えには数字の点数 (プラスまたはマイナス) が与えられます。';
$string['deadline'] = '終了日時';
$string['defaultessayresponse'] = 'あなたの作文はあなたの教師によって評定されます。';
$string['deleteallattempts'] = 'すべてのレッスン受験を削除する';
$string['deletedefaults'] = '{$a} x レッスンデフォルトを削除しました。';
$string['deletedpage'] = 'ページを削除しました';
$string['deletepagenamed'] = 'ページを削除する: {$a}';
$string['deleting'] = '削除中';
$string['deletingpage'] = 'ページの削除: {$a}';
$string['dependencyon'] = '依存対象';
$string['dependencyon_help'] = 'この設定により、現在のレッスンを同一コース内の別レッスンにおける学生の成績に依存させることができます。「利用時間」「完了」または「評点が上」のどのような組み合わせでも使用することができます。';
$string['description'] = '説明';
$string['detailedstats'] = '詳細統計';
$string['didnotanswerquestion'] = 'この問題に解答していません。';
$string['didnotreceivecredit'] = '承認なし';
$string['disabled'] = '無効';
$string['displaydefaultfeedback'] = 'デフォルトフィードバックを使用する';
$string['displaydefaultfeedback_help'] = 'この設定を有効にした場合、問題のレスポンスが見つからない場合にデフォルトレスポンスの「正解です」および「不正解です」が表示されます。';
$string['displayhighscores'] = 'ハイスコアを表示する';
$string['displayinleftmenu'] = 'メニューに表示しますか?';
$string['displayleftif'] = 'メニューを表示するための最小評点';
$string['displayleftif_help'] = 'この設定ではレッスンメニューが表示される前に学生が特定の評点を取得する必要があるかどうか設定します。これにより最初の受験でレッスンすべてを通すことを学生に強制します。要求される評点を取得した後、学生はレビューのためにメニューを使用することができます。';
$string['displayleftmenu'] = 'メニューを表示する';
$string['displayleftmenu_help'] = 'この設定を有効にした場合、ページ一覧に移動することのできるメニューをユーザに表示できるようにします。';
$string['displayofgrade'] = '評点を表示する (学生のみ)';
$string['displayreview'] = '問題の再受験オプションを提供する';
$string['displayreview_help'] = 'この設定を有効にした場合、問題が不正解のときに学生が評点なしで再受験するまたはレッスンを続けるオプションを提供します。';
$string['displayscorewithessays'] = '<p>自動評定によるあなたの評点は {$a->tempmaxgrade} 点中 {$a->score} 点です。</p>
<p>作文問題 {$a->essayquestions} が評定された後、あなたの最終評点に後日追加されます。</p>
<p>作文問題を除くあなたの現在の評点は {$a->grade} 点中 {$a->score} 点です。</p>';
$string['displayscorewithoutessays'] = 'あなたの評点は {$a->score} ({$a->grade} 点中)です。';
$string['duplicatepagenamed'] = 'ページを複製する: {$a}';
$string['edit'] = '編集';
$string['editingquestionpage'] = '{$a} 問題ページの編集';
$string['editlessonsettings'] = 'レッスン設定を編集する';
$string['editoverride'] = 'オーバーライドを編集する';
$string['editpage'] = 'ページコンテンツを編集する';
$string['editpagecontent'] = 'ページコンテンツを編集する';
$string['email'] = 'メール';
$string['emailallgradedessays'] = 'すべての作文問題の評定結果を<br />メール送信する';
$string['emailgradedessays'] = '作文問題の評定結果をメール送信する';
$string['emailsuccess'] = 'メールが正常に送信されました。';
$string['emptypassword'] = 'パスワードは空白にできません。';
$string['enabled'] = '有効';
$string['endofbranch'] = '終了ブランチ';
$string['endofcluster'] = '終了クラスタ';
$string['endofclustertitle'] = '終了クラスタ';
$string['endoflesson'] = 'レッスン終了';
$string['enteredthis'] = '入力されました。';
$string['entername'] = 'ハイスコアリストのニックネームを入力してください。';
$string['enterpassword'] = 'パスワードを入力してください:';
$string['eolstudentoutoftime'] = 'お知らせ: このレッスンの制限時間が終了しました。制限時間終了後に解答した場合、解答内容はカウントされません。';
$string['eolstudentoutoftimenoanswers'] = 'あなたはどの問題にも解答していません。このレッスンのあなたの評点は0点です。';
$string['essay'] = '作文問題';
$string['essayemailmessage2'] = '<p>作文問題:{$a->question}</p>
<p>あなたの解答:<em>{$a->response}</em></p>
<p>評価者のコメント:<em>{$a->comment}</em></p>
<p>この作文問題の評点は {$a->earned} /{$a->outof} です。</p>
<p>あなたのレッスン {$a->lesson} の評点は {$a->newgrade}% に変更されました。</p>';
$string['essayemailsubject'] = 'レッスン問題に関して利用可能な評点';
$string['essayresponses'] = '作文問題の解答';
$string['essays'] = '作文問題';
$string['essayscore'] = '作文問題の評点';
$string['eventcontentpageviewed'] = 'コンテンツページが閲覧されました。';
$string['eventessayassessed'] = '作文が評価されました。';
$string['eventessayattemptviewed'] = '作文問題の受験が閲覧されました。';
$string['eventhighscoreadded'] = 'ハイスコアが追加されました。';
$string['eventhighscoresviewed'] = 'ハイスコアが閲覧されました。';
$string['eventlessonended'] = 'レッスンが終了しました。';
$string['eventlessonrestarted'] = 'レッスンが再開されました。';
$string['eventlessonresumed'] = 'レッスンが中断されました。';
$string['eventlessonstarted'] = 'レッスンが開始しました。';
$string['eventoverridecreated'] = 'レッスンオーバーライドが作成されました。';
$string['eventoverridedeleted'] = 'レッスンオーバーライドが削除されました。';
$string['eventoverrideupdated'] = 'レッスンオーバーライドが更新されました。';
$string['eventpagecreated'] = 'ページが作成されました。';
$string['eventpagedeleted'] = 'ページが削除されました。';
$string['eventpagemoved'] = 'ページが移動されました。';
$string['eventpageupdated'] = 'ページが更新されました。';
$string['eventquestionanswered'] = '問題が解答されました。';
$string['eventquestionviewed'] = '問題が閲覧されました。';
$string['false'] = '×';
$string['fileformat'] = 'ファイルフォーマット';
$string['finish'] = '終了';
$string['firstanswershould'] = '最初の答えは「正しい」ページにジャンプしてください。';
$string['firstwrong'] = 'あなたの解答は正しくありません。問題を再度受験しますか?  (今から問題に正しく解答した場合、あなたの最終評点には加算されません)';
$string['flowcontrol'] = 'フローコントロール';
$string['fractionsaddwrong'] = 'あなたが選択したプラス評点の合計が100%になっていません。<br />現在の評点合計は {$a}% です。<br />戻ってこの問題を修正しますか?';
$string['fractionsnomax'] = 'この問題で満点を取ることができるよう<br />答えの1つは100%でなければなりません。 <br />戻ってこの問題を修正しますか?';
$string['full'] = '展開する';
$string['general'] = '一般設定';
$string['gotoendoflesson'] = 'レッスンの最後に移動する';
$string['grade'] = '評点';
$string['gradebetterthan'] = '評点が上 (&#37;)';
$string['gradebetterthanerror'] = '{$a} パーセントより多い評点が与えられています。';
$string['gradeessay'] = '作文問題の評定 (評定未了: {$a->notgradedcount} 件 / 送信未了 {$a->notsentcount} 件)';
$string['gradeis'] = '評点は {$a} です';
$string['gradeoptions'] = '評定オプション';
$string['groupoverrides'] = 'グループオーバーライド';
$string['groupoverridesdeleted'] = 'グループオーバーライドが削除されました。';
$string['groupsnone'] = 'このコース内にグループはありません。';
$string['handlingofretakes'] = '再受験の評定方法';
$string['handlingofretakes_help'] = '再受験が許可された場合、この設定はレッスンの評定がすべての受験の平均または最高を指定します。';
$string['havenotgradedyet'] = '未評定';
$string['here'] = '　';
$string['highscore'] = '最高評点';
$string['highscores'] = 'ハイスコア';
$string['hightime'] = '最長時間';
$string['importcount'] = '{$a} の問題をインポート';
$string['importquestions'] = '問題をインポートする';
$string['importquestions_help'] = 'この機能では様々なフォーマットの問題をテキストファイルでインポートすることができます。';
$string['inactiveoverridehelp'] = '* 学生にはレッスンを閲覧および受験するための正しいグループまたはロールがありません。';
$string['insertedpage'] = 'ページが追加されました';
$string['invalidfile'] = '無効なファイル';
$string['invalidid'] = 'コースモジュールIDまたはレッスンIDがパスしていません。';
$string['invalidlessonid'] = 'レッスンIDが正しくありません。';
$string['invalidoverrideid'] = '無効なオーバーライドID';
$string['invalidpageid'] = 'ページIDが正しくありません。';
$string['jump'] = 'ジャンプ';
$string['jumps'] = 'ジャンプ';
$string['jumps_help'] = 'それぞれの (問題の) 答えまたは (コンテンツページの) 説明はジャンプするリンク先を持ちます。ジャンプには「このページ」または「次のページ」のような相対ジャンプまたはレッスン内の1ページを指定する絶対ジャンプがあります。';
$string['jumpsto'] = '<em>{$a}</em> にジャンプする';
$string['leftduringtimed'] = 'あなたは制限時間のあるレッスンを途中で終了しました。<br />レッスンを再スタートするには「続ける」をクリックしてください。';
$string['leftduringtimednoretake'] = 'あなたは制限時間のあるレッスンを途中で終了しました。<br />レッスンを再受験または継続は許可されていません。';
$string['leftduringtimedsession'] = 'あなたは制限時間のあるレッスンを離れました。';
$string['lesson:addinstance'] = '新しいレッスンを追加する';
$string['lessonclosed'] = 'このレッスンは {$a} に終了します。';
$string['lessoncloses'] = 'レッスン終了';
$string['lessoncloseson'] = 'レッスン終了: {$a}';
$string['lesson:edit'] = 'レッスン活動を編集する';
$string['lessonformating'] = 'レッスンフォーマット';
$string['lesson:grade'] = 'レッスン作文問題を評定する';
$string['lesson:manage'] = 'レッスン活動を管理する';
$string['lesson:manageoverrides'] = 'レッスンオーバーライドを管理する';
$string['lessonmenu'] = 'レッスンメニュー';
$string['lessonname'] = 'レッスン: {$a}';
$string['lessonnotready'] = 'このレッスンはまだ受験することができません。あなたの {$a} にご連絡ください。';
$string['lessonnotready2'] = 'このレッスンはまだ受験することができません';
$string['lessonopen'] = 'このレッスンは {$a} に開始されます。';
$string['lessonopens'] = 'レッスン開始';
$string['lessonpagelinkingbroken'] = '最初のページが見つかりません。レッスンページのリンクが壊れているようです。管理者にご連絡ください。';
$string['lessonstats'] = 'レッスン統計';
$string['lesson:view'] = 'レッスン活動を表示する';
$string['lesson:viewreports'] = 'レッスンレポートを表示する';
$string['linkedmedia'] = 'リンクメディア';
$string['loginfail'] = 'ログインに失敗しました、再度ログインしてください ...';
$string['lowscore'] = '最低評点';
$string['lowtime'] = '最短時間';
$string['manualgrading'] = '作文問題の評定';
$string['matchesanswer'] = '正解';
$string['matching'] = '組み合わせ問題';
$string['matchingpair'] = '組み合わせペア {$a}';
$string['maxgrade'] = '最大評点';
$string['maxgrade_help'] = 'ここではレッスンの最大評点を設定します。ゼロが設定された場合、そのレッスンは評定ページに表示されません。';
$string['maxhighscores'] = 'ハイスコア表示件数';
$string['maximumnumberofanswersbranches'] = '答えの最大数';
$string['maximumnumberofanswersbranches_help'] = 'ここでは小テストで使用される解答の最大数を指定します。○/×問題のみ使用する場合、設定値として2を設定することができます。データではなく教師の見え方のみに影響するため、設定内容はいつでも変更することができます。';
$string['maximumnumberofattempts'] = '最大受験回数';
$string['maximumnumberofattempts_help'] = 'この設定ではそれぞれの問題に許可される最大受験回数を指定します。答えが繰り返し正しくない場合、最大受験回数に到達した時点で次のレッスンページが表示されます。';
$string['maximumnumberofattemptsreached'] = '最大受験回数に達しました - 次のページに移動しています。';
$string['mediaclose'] = '「ウィンドウを閉じる」ボタンを表示する';
$string['mediafile'] = 'リンクメディア';
$string['mediafile_help'] = 'レッスンで使用するためにメディアファイルをアップロードすることができます。レッスンのそれぞれのページにある「リンクメディア」ブロックに「閲覧するにはここをクリックしてください」リンクが表示されます。';
$string['mediafilepopup'] = '閲覧するにはここをクリックしてください。';
$string['mediaheight'] = 'ポップアップウィンドウ高';
$string['mediawidth'] = 'ポップアップウィンドウ幅';
$string['messageprovider:graded_essay'] = 'レッスン作文評定通知';
$string['minimumnumberofquestions'] = '最小問題数';
$string['minimumnumberofquestions_help'] = 'ここでは活動の評定計算に使用する問題の最大数を指定します。';
$string['missingname'] = 'ニックネームを入力してください。';
$string['modattempts'] = '学生のレビューを許可する';
$string['modattempts_help'] = 'この設定を有効にした場合、学生は再度レッスンを最初から通すことができます。';
$string['modattemptsnoteacher'] = '学生レビューは学生のみに表示されます。';
$string['modulename'] = 'レッスン';
$string['modulename_help'] = 'レッスン活動において、教師は楽しくフレキシブルな方法でコンテンツおよび実践活動を提供することができます。教師は一連の線形のコンテンツパッケージまたは学習者に様々なパスまたはオプションを提供する教育活動のためにレッスンを使用することができます。どちらの場合でも、教師は参加を増やすこと、および多肢選択問題、組み合わせ問題、記述問題等の様々な問題を含むことで、理解を確かめることができます。学生の選択した答えおよび教師のレッスン開発により、学生を次のページに移動させる、前のページに戻す、または完全に異なるパスにリダイレクトさせることができます。

レッスンは評定すること、評点を評定表に記録することができます。

レッスンは下記のように使用することができます:

* 新しいテーマに関する自主学習のため
* シナリオまたはシミュレーション/意思決定訓練のため
* 初期問題で答えられた内容により、一連の異なる試験問題を提供する差別化された試験対策として';
$string['modulenameplural'] = 'レッスン';
$string['move'] = 'ページを移動する';
$string['movedpage'] = 'ページを移動しました。';
$string['movepagehere'] = 'ページをここに移動する';
$string['movepagenamed'] = 'ページを移動する: {$a}';
$string['moving'] = 'ページの移動: {$a}';
$string['multianswer'] = '複数解答';
$string['multianswer_help'] = '1つ以上の解答を正解にする場合、この設定を有効にしてください。';
$string['multichoice'] = '多肢選択問題';
$string['multipleanswer'] = '複数解答';
$string['nameapproved'] = '名前が承認されました。';
$string['namereject'] = '申し訳ございません、あなたの名前はフィルタにより拒否されました。<br />別の名前をお使いください。';
$string['new'] = '新しい';
$string['nextpage'] = '次のページ';
$string['noanswer'] = '1つまたはそれ以上の問題が解答されていません。戻って解答を送信してください。';
$string['noattemptrecordsfound'] = '受験レコードが見つかりません: 評定なし';
$string['nobranchtablefound'] = 'コンテンツページが見つかりません。';
$string['noclose'] = '終了日時なし';
$string['nocommentyet'] = 'コメントはありません。';
$string['nocoursemods'] = '活動が見つかりません。';
$string['nocredit'] = '未承認';
$string['nodeadline'] = 'レッスン終了なし';
$string['noessayquestionsfound'] = 'このレッスンに作文問題はありません。';
$string['nohighscores'] = 'ハイスコアはありません。';
$string['nolessonattempts'] = 'このレッスンは受験されていません。';
$string['nolessonattemptsgroup'] = 'このレッスンの {$a} グループメンバーによる受験はありません。';
$string['none'] = 'なし';
$string['nooneansweredcorrectly'] = '正解者はいません。';
$string['nooneansweredthisquestion'] = 'この問題の解答者はいません。';
$string['noonecheckedthis'] = '未チェック';
$string['nooneenteredthis'] = '未入力';
$string['noonehasanswered'] = 'まだ作文問題に解答者はいません。';
$string['noonehasansweredgroup'] = 'まだ {$a} の誰も作文問題に解答していません。';
$string['noopen'] = '開始日時なし';
$string['nooverridedata'] = 'あなたは少なくとも1つのレッスン設定をオーバーライドする必要があります。';
$string['noretake'] = 'あなたはこのレッスンを再受験できません。';
$string['normal'] = '通常 - レッスンパスに従う';
$string['notcompleted'] = '未了';
$string['notdefined'] = '未定義';
$string['notenoughsubquestions'] = '十分な副問題が定義されていません！';
$string['notenoughtimespent'] = 'あなたはこのレッスンを所要時間 {$a->timerequired} より短い {$a->timespent} で完了しました。あなたは再度レッスンを受験することができます。';
$string['nothighscore'] = 'あなたはトップ {$a} ハイスコアリストに入りませんでした。';
$string['notitle'] = 'タイトルなし';
$string['notyetcompleted'] = 'レッスンは開始されましたが、まだ完了していません。';
$string['numberofcorrectanswers'] = '正解数: {$a}';
$string['numberofcorrectanswersheader'] = '正解数';
$string['numberofcorrectmatches'] = '正しいマッチ数: {$a}';
$string['numberofpagestoshow'] = 'ページ表示数';
$string['numberofpagestoshow_help'] = 'この設定ではレッスンで表示されるページ数を指定します。これはページがランダムに表示される場合のみに適用されます (「正解後のアクション」 が 「未閲覧のページを表示する」または「未解答のページを表示する」に設定された場合)。ゼロが設定された場合、すべてのページが表示されます。';
$string['numberofpagesviewed'] = '解答済み問題数: {$a}';
$string['numberofpagesviewedheader'] = '解答済み問題数';
$string['numberofpagesviewednotice'] = '解答済み問題数: {$a->nquestions} (あなたは少なくとも {$a->minquestions} 問の問題に解答する必要があります)';
$string['numerical'] = '数値問題';
$string['ongoing'] = '進行中の評点を表示する';
$string['ongoingcustom'] = '現在、あなたの評点は {$a->currenthigh} 点中 {$a->score} 点です。';
$string['ongoing_help'] = 'この設定を有効にした場合、現時点で考えられる学生の合計評点がそれぞれのページに表示されます。';
$string['ongoingnormal'] = 'あなたは {$a->viewed} 問中 {$a->correct} 問を正しく答えました。';
$string['onpostperpage'] = '1評点あたり1回のみ登録してください。';
$string['options'] = 'オプション';
$string['or'] = 'または';
$string['ordered'] = '整理済み';
$string['other'] = 'その他';
$string['outof'] = '{$a} 中';
$string['override'] = 'オーバーライド';
$string['overridedeletegroupsure'] = '本当にグループ「 {$a} 」のオーバーライドを削除してもよろしいですか?';
$string['overridedeleteusersure'] = '本当にユーザ「 {$a} 」のオーバーライドを削除してもよろしいですか?';
$string['overridegroup'] = 'グループをオーバーライドする';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'オーバーライド';
$string['overrideuser'] = 'ユーザをオーバーライドする';
$string['overrideusereventname'] = '{$a->lesson} - オーバーライド';
$string['overview'] = '概要';
$string['overview_help'] = 'レッスンは多くのページおよび任意のコンテンツページにより構成されます。ページはいくつかのコンテンツを含み、通常、問題で終了します。ジャンプには「このページ」または「次のページ」のような相対ジャンプまたはレッスン内の1ページを指定する絶対ジャンプがあります。ページコンテンツには例えば目次のようにレッスン内の他のページへの一連のリンクを含みます。';
$string['page'] = 'ページ: {$a}';
$string['pageanswers'] = '正解ページ';
$string['pagecontents'] = 'ページコンテンツ';
$string['page-mod-lesson-edit'] = 'レッスンページを編集する';
$string['page-mod-lesson-view'] = 'レッスンページを表示またはプレビューする';
$string['page-mod-lesson-x'] = 'すべてのレッスンページ';
$string['pageresponses'] = '解答ページ';
$string['pages'] = 'ページ';
$string['pagetitle'] = 'ページタイトル';
$string['password'] = 'パスワード';
$string['passwordprotectedlesson'] = '{$a} はパスワードで保護されたレッスンです。';
$string['pleasecheckoneanswer'] = '1つの答えをチェックしてください';
$string['pleasecheckoneormoreanswers'] = '1つ以上の答えをチェックしてください';
$string['pleaseenteryouranswerinthebox'] = 'あなたの答えをテキストボックスに入力してください';
$string['pleasematchtheabovepairs'] = '上の組み合わせを合致させてください';
$string['pluginadministration'] = 'レッスン管理';
$string['pluginname'] = 'レッスン';
$string['pointsearned'] = '獲得点数';
$string['postprocesserror'] = '投稿処理中にエラーが発生しました!';
$string['postsuccess'] = '正常に投稿されました。';
$string['practice'] = '練習レッスン';
$string['practice_help'] = '練習レッスンは評定表には表示されません。';
$string['preprocesserror'] = '前処理中にエラーが発生しました!';
$string['prerequisiteisobsolete'] = '必修レッスンオプションは削除される予定です。代わりにアクセス制限を使用してください。';
$string['prerequisitelesson'] = '必修レッスン';
$string['preview'] = 'プレビュー';
$string['previewlesson'] = '{$a} のプレビュー';
$string['previewpagenamed'] = 'ページをプレビューする: {$a}';
$string['previouspage'] = '前のページ';
$string['processerror'] = '処理中にエラーが発生しました!';
$string['progressbar'] = 'プログレスバー';
$string['progressbar_help'] = 'この設定を有効にした場合、レッスンページ最下部におおよその完了パーセンテージを表示したバーが表示されます。';
$string['progressbarteacherwarning'] = 'プログレスバーは {$a} に表示されません。';
$string['progressbarteacherwarning2'] = 'あなたはこのレッスンを編集できるため、プログレスバーは表示されません。';
$string['progresscompleted'] = 'あなたは {$a}% のレッスンを完了しました。';
$string['qtype'] = 'ページタイプ';
$string['question'] = '問題';
$string['questionoption'] = '問題';
$string['questiontype'] = '問題タイプ';
$string['randombranch'] = 'ランダムコンテンツページ';
$string['randompageinbranch'] = 'コンテンツページ内のランダム問題';
$string['rank'] = 'ランク';
$string['rawgrade'] = '素点';
$string['receivedcredit'] = '承認クレジット';
$string['redisplaypage'] = 'ページを再表示する';
$string['removeallgroupoverrides'] = 'すべてのグループオーバーライドを削除する';
$string['removealluseroverrides'] = 'すべてのユーザオーバーライドを削除する';
$string['report'] = 'レポート';
$string['reports'] = 'レポート';
$string['response'] = '返答';
$string['retakesallowed'] = '再受験を許可する';
$string['retakesallowed_help'] = 'この設定を有効にした場合、学生は1回以上レッスンを受験することができます。';
$string['returnto'] = '{$a} に戻る';
$string['returntocourse'] = 'コースに戻る';
$string['reverttodefaults'] = 'レッスンデフォルトに戻す';
$string['review'] = 'レビュー';
$string['reviewlesson'] = 'レッスンをレビューする';
$string['reviewquestionback'] = 'はい、もう一度受験します';
$string['reviewquestioncontinue'] = 'いいえ、次の問題に移動します';
$string['sanitycheckfailed'] = '正当性チェックが失敗しました: この受験は削除されました。';
$string['save'] = '保存';
$string['savechanges'] = '変更を保存する';
$string['savechangesandeol'] = 'すべての変更を保存してレッスンの最後に移動する。';
$string['saveoverrideandstay'] = '保存して別のオーバーライドを入力する';
$string['savepage'] = 'ページを保存する';
$string['score'] = '評点';
$string['score_help'] = '評点はカスタムスコアが有効にされた場合にのみ使用されます。それぞれの答えには数字による評点 (プラスまたはマイナス) を与えることができます。';
$string['scores'] = '評点';
$string['search:activity'] = 'レッスン - 活動情報';
$string['secondpluswrong'] = 'もう一度受験しますか?';
$string['selectaqtype'] = '問題タイプを選択する';
$string['shortanswer'] = '記述問題';
$string['showanunansweredpage'] = '未解答のページを表示する';
$string['showanunseenpage'] = '未閲覧のページを表示する';
$string['singleanswer'] = '単一解答';
$string['skip'] = 'ナビゲーションをスキップする';
$string['slideshow'] = 'スライドショー';
$string['slideshowbgcolor'] = 'スライドショー背景色';
$string['slideshowheight'] = 'スライドショー高';
$string['slideshow_help'] = 'この設定を有効にした場合、レッスンは固定幅および高さのスライドショーとして表示されます。';
$string['slideshowwidth'] = 'スライドショー幅';
$string['startlesson'] = 'レッスンを開始する';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname} さんの受験回数:  {$a->attempt}';
$string['studentname'] = '{$a} の氏名';
$string['studentoneminwarning'] = '警告: レッスンが終了するまでの残り時間が1分またはそれ以下です。';
$string['studentresponse'] = '{$a} の解答';
$string['submit'] = '送信';
$string['submitname'] = '氏名を送信する';
$string['teacherjumpwarning'] = 'このレッスンでは {$a->cluster} ジャンプまたは {$a->unseen} ジャンプが使用されています。代わりに「次のページ」へのジャンプが使用されます。これらのジャンプを確認するには学生としてログインしてください。';
$string['teacherongoingwarning'] = '進行中の評点は学生にのみ表示されます。進行中のスコアをテストするには学生としてログインしてください。';
$string['teachertimerwarning'] = 'タイマーは学生に対してのみ作動します。タイマーをテストするには学生としてログインしてください。';
$string['thatsthecorrectanswer'] = '正解です。';
$string['thatsthewronganswer'] = '不正解です。';
$string['thefollowingpagesjumptothispage'] = '以下ののページはこのページにジャンプします。';
$string['thispage'] = 'このページ';
$string['timeisup'] = '時間終了';
$string['timelimit'] = '時間制限';
$string['timelimit_help'] = 'この設定を有効にした場合、レッスン開始時に時間制限に関する警告が表示され、カウントダウンタイマーが表示されます。制限時間後の解答は評定されません。';
$string['timelimitwarning'] = 'あなたはレッスン終了までに {$a} あります。';
$string['timeremaining'] = '残り時間';
$string['timespenterror'] = '少なくともレッスンで {$a} 分の時間を費やしてください。';
$string['timespentminutes'] = '利用時間 (分)';
$string['timetaken'] = '経過時間';
$string['topscorestitle'] = 'トップ {$a} ハイスコア';
$string['totalpagesviewedheader'] = 'ページ閲覧数';
$string['true'] = '○';
$string['truefalse'] = '○/×問題';
$string['unabledtosavefile'] = 'あなたがアップロードしたファイルを保存することができませんでした。';
$string['unknownqtypesnotimported'] = '{$a} 件のサポートされない問題タイプがインポートされませんでした。';
$string['unseenpageinbranch'] = 'コンテンツページ内の未閲覧の問題';
$string['unsupportedqtype'] = 'サポートされていない問題タイプ ({$a}) です!';
$string['updatedpage'] = 'ページを更新しました';
$string['updatefailed'] = '更新に失敗しました。';
$string['updatepagenamed'] = 'ページを更新する: {$a}';
$string['usemaximum'] = '最大評点を使用する';
$string['usemean'] = '評点平均を使用する';
$string['usepassword'] = 'パスワード保護レッスン';
$string['usepassword_help'] = 'この設定を有効にした場合、レッスンにアクセスするためにパスワードが必要となります。';
$string['useroverrides'] = 'ユーザオーバーライド';
$string['useroverridesdeleted'] = 'ユーザオーバーライドが削除されました。';
$string['usersnone'] = 'このレッスンにアクセスできる学生はいません。';
$string['viewgrades'] = '評点を表示する';
$string['viewhighscores'] = 'ハイスコアリストを表示する';
$string['viewreports'] = '{$a->student} の {$a->attempts} 件の受験を表示する';
$string['viewreports2'] = '{$a} 件の受験を表示する';
$string['warning'] = '警告';
$string['welldone'] = 'よくできました!';
$string['whatdofirst'] = '最初に何をしますか?';
$string['wronganswerjump'] = '不正解のジャンプ先';
$string['wronganswerscore'] = '不正解の評点';
$string['wrongresponse'] = '不正解';
$string['xattempts'] = '{$a} 受験';
$string['youhaveseen'] = 'あなたはすでにこのレッスンを1ページ以上表示しました。<br />あなたが表示した最後のページから始めますか?';
$string['youmadehighscore'] = 'あなたはトップ {$a} ハイスコアリストに入りました。';
$string['youranswer'] = 'あなたの答え';
$string['yourcurrentgradeis'] = 'あなたの現在の評点は {$a} です。';
$string['yourcurrentgradeisoutof'] = 'あなたの現在の評点は {$a->total} 点中 {$a->grade} 点です。';
$string['youshouldview'] = '少なくとも {$a} 回解答してください。';
