<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlecloudsignup', language 'ja', branch 'MOODLE_31_STABLE'
 *
 * @package   local_moodlecloudsignup
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['FOSUserBundle:change_password.flash.success'] = 'パスワードが変更されました。';
$string['FOSUserBundle:change_password.submit'] = 'パスワードを変更する';
$string['FOSUserBundle:form.current_password'] = '現在のパスワード:';
$string['FOSUserBundle:form.email'] = 'Eメール:';
$string['FOSUserBundle:form.group_name'] = 'グループ名:';
$string['FOSUserBundle:form.new_password'] = '新しいパスワード:';
$string['FOSUserBundle:form.new_password_confirmation'] = '新しいパスワードをもう一度:';
$string['FOSUserBundle:form.password'] = 'パスワード:';
$string['FOSUserBundle:form.password_confirmation'] = 'パスワードをもう一度:';
$string['FOSUserBundle:form.username'] = 'ユーザ名:';
$string['FOSUserBundle:group.edit.submit'] = 'グループを更新する';
$string['FOSUserBundle:group.flash.created'] = 'グループが作成されました。';
$string['FOSUserBundle:group.flash.deleted'] = 'グループが削除されました。';
$string['FOSUserBundle:group.flash.updated'] = 'グループが更新されました。';
$string['FOSUserBundle:group.new.submit'] = 'グループを作成する';
$string['FOSUserBundle:group.show.name'] = 'グループ名';
$string['FOSUserBundle:layout.logged_in_as'] = '%username% としてログインする';
$string['FOSUserBundle:layout.login'] = 'ログイン';
$string['FOSUserBundle:layout.logout'] = 'ログアウト';
$string['FOSUserBundle:layout.register'] = '登録';
$string['FOSUserBundle:profile.edit.submit'] = '更新';
$string['FOSUserBundle:profile.flash.updated'] = 'プロファイルが更新されました。';
$string['FOSUserBundle:profile.show.email'] = 'Eメール';
$string['FOSUserBundle:profile.show.username'] = 'ユーザ名';
$string['FOSUserBundle:registration.back'] = '元のページに戻ります。';
$string['FOSUserBundle:registration.check_email'] = '%email% 宛にメールが送信されました。メールにはあなたがアカウントを有効化するためにクリックする必要のある有効化リンクが含まれています。';
$string['FOSUserBundle:registration.confirmed'] = '%username% さん、おめでとうございます。あなたのアカウントが有効化されました。';
$string['FOSUserBundle:registration.email.message'] = '%username% さん、こんにちは!

あなたのアカウントを有効化するには %confirmationUrl% にアクセスしてください。

MoodleCloudチーム';
$string['FOSUserBundle:registration.email.subject'] = 'ようこそ %username% さん!';
$string['FOSUserBundle:registration.flash.user_created'] = 'ユーザが正常に作成されました。';
$string['FOSUserBundle:registration.submit'] = '登録';
$string['FOSUserBundle:resetting.check_email'] = '%email% 宛にメールが送信されました。メールにはあなたのパスワードをリセットするためのリンクが含まれています。';
$string['FOSUserBundle:resetting.email.message'] = '%username% さん、こんにちは!

あなたのアカウントをリセットするには %confirmationUrl% にアクセスしてください。

MoodleCloudチーム';
$string['FOSUserBundle:resetting.email.subject'] = 'パスワードをリセットする';
$string['FOSUserBundle:resetting.flash.success'] = 'パスワードが正常にリセットされました。';
$string['FOSUserBundle:resetting.password_already_requested'] = 'このユーザのパスワードはすでに24時間以内にリクエストされています。';
$string['FOSUserBundle:resetting.request.invalid_username'] = 'ユーザ名またはメールアドレス「 %username% 」が存在しません。';
$string['FOSUserBundle:resetting.request.submit'] = 'パスワードをリセットする';
$string['FOSUserBundle:resetting.request.username'] = 'ユーザ名またはメールアドレス:';
$string['FOSUserBundle:resetting.reset.submit'] = 'パスワードを変更する';
$string['FOSUserBundle:security.login.password'] = 'パスワード:';
$string['FOSUserBundle:security.login.remember_me'] = '次回から入力を省略する';
$string['FOSUserBundle:security.login.submit'] = 'ログイン';
$string['FOSUserBundle:security.login.username'] = 'ユーザ名:';
$string['homepage:general.servicestatus'] = 'サービスステータス';
$string['homepage:page.description'] = 'Moodleから利用できるMoodleホスティングソリューションは誰でもクラウド上で学習ソフトウェアを稼働させることができます。';
$string['homepage:page.title'] = 'MoodleCloud: Moodle開発元によるフリーホスティングサービス';
$string['langconfig:direction'] = 'ltr';
$string['langconfig:langname'] = '英語';
$string['login:security.login.password'] = 'パスワード';
$string['login:security.login.password_placeholder'] = 'パスワード';
$string['login:security.login.submit'] = 'ログイン';
$string['pluginname'] = 'MoodleCloudサインアップおよびポータル設定';
$string['portal:graphs.axes.dbsize'] = 'データベースサイズ';
$string['portal:graphs.axes.filesize'] = 'ファイルサイズ';
$string['portal:graphs.axes.users'] = 'ユーザ';
$string['portal:graphs.filetypes.application'] = 'アプリケーションデータ';
$string['portal:graphs.filetypes.audio'] = 'オーディオ';
$string['portal:graphs.filetypes.example'] = '例';
$string['portal:graphs.filetypes.image'] = 'イメージ';
$string['portal:graphs.filetypes.message'] = 'メッセージ';
$string['portal:graphs.filetypes.model'] = 'モデル';
$string['portal:graphs.filetypes.multipart'] = 'マルチパートアイテム';
$string['portal:graphs.filetypes.text'] = 'テキスト';
$string['portal:graphs.filetypes.video'] = 'ビデオ';
$string['portal:historical.fetchfailure.lead'] = '申し訳ございません、私たちはあなたの歴史的データを検索できませんでした。あなたが後で戻ってくることにより、私たちは何か提供できるかもしれません。';
$string['portal:list.body.lead'] = '&nbsp;';
$string['portal:list.table.titles.location'] = 'ロケーション';
$string['portal:list.table.titles.subdomain'] = 'サブドメイン';
$string['portal:messages.csrffailure'] = '変更を確認できません。再度お試しください。';
$string['portal:messages.removalqueued'] = '削除のために待ち行列中';
$string['portal:messages.sitenotfound'] = 'サイトを読み込めませんでした。もう一度お試しください。';
$string['portal:page.title'] = 'MoodleCloud: ポータル';
$string['portal:siteinfo.page.title'] = 'MoodleCloud: %subdomain% サイト情報';
$string['portal:siteinfo.panels.historical.title'] = '歴史的データ';
$string['portal:siteinfo.panels.info.status'] = 'ステータス';
$string['portal:siteinfo.panels.info.title'] = '情報';
$string['portal:siteinfo.panels.info.version'] = 'バージョン';
$string['portal:siteinfo.panels.statistics.title'] = '統計';
$string['portal:statistics.fetchfailure.lead'] = '申し訳ございません、私たちはあなたの現在の統計を検索できませんでした。あなたが後で戻ってくることにより、私たちは何か提供できるかもしれません。';
$string['portal:statistics.graphs.databasesize'] = 'データベースサイズ';
$string['portal:statistics.graphs.files'] = 'ファイル';
$string['portal:statistics.graphs.users'] = 'ユーザ';
$string['portal:view.danger.modal.title'] = '削除確認';
$string['portal:view.danger.panel.body.buttons.remove'] = '私のMoodleCloudサイトを削除する';
$string['portal:view.danger.panel.body.lead'] = '<p>あなたがこのMoodleCloudサイトを削除した場合、本当になくなってしまいます。</p>
<p>あなたがMoodleCloudサイトの利用を終了して、必要なコンテンツすべてを精査したことを確かめてください。</p>';
$string['portal:view.danger.panel.body.title'] = '私のMoodleCloudサイトを削除する';
$string['portal:view.danger.panel.title'] = '恐ろしいこと';
$string['signup:authcode.body.links.startover'] = 'やり直しますか? <a href="%link%">最初に戻りましょう</a>。';
$string['signup:authcode.form.placeholders.authcode'] = '123456';
$string['signup:errors.blacklistinline'] = '申し訳ございません、そのサイトは利用できません。';
$string['signup:errors.reserved'] = 'まさか! すでに誰かが取得しています。';
$string['signup:messages.failedvalidationcode'] = '何か大きく間違っているようです。あなたは正しく入力しましたか?';
$string['signup:messages.passwordupdated'] = '素晴らしい! 私たちはあなたのパスワードを更新しました。あなたのMoodleCloudサイトのログインに使用することができます。';
$string['signup:messages.validationcode'] = 'MoodleCloudからこんにちは! 「%code%」 - %subdomain%.moodlecloud.comのセットアップ処理を完了するためにこの確認コードを使用してください。';
$string['signup:page.description'] = '1つのインスタンスにMoodleサイトを配置するため教師および指導者にクラウドサーバで提供されるフリーのMoodle学習ソフトウェアです。';
$string['signup:password.form.fields.password_confirmation'] = '新しいパスワードをもう一度';
$string['signup:password.form.placeholders.password'] = '&nbsp;';
$string['signup:password.form.placeholders.password_confirmation'] = '&nbsp;';
$string['signup:personal.form.fields.email'] = 'Eメールアドレス';
$string['signup:personal.form.fields.firstname'] = '名';
$string['signup:personal.form.fields.lastname'] = '姓';
$string['signup:personal.form.fields.phonenumber'] = '携帯電話番号';
$string['signup:personal.form.fields.timezone'] = 'あなたのタイムゾーン';
$string['signup:personal.form.placeholders.email'] = '&nbsp;';
$string['signup:personal.form.placeholders.firstname'] = '&nbsp;';
$string['signup:personal.form.placeholders.lastname'] = '&nbsp;';
$string['signup:personal.form.placeholders.phonenumber'] = '&nbsp;';
$string['signup:personal.form.placeholders.timezone'] = 'タイムゾーンを選択する';
$string['signup:provision_mail.page.html'] = '<h1>ようこそMoodleCloudへ!</h1>
<p>あなたのフリーのMoodleサイト<a href="%url%">%url%</a>が作成されました。</p>
<p>あなたのMoodleサイトにユーザ名「admin」およびサインアップ時に設定したパスワードを使用してログインすることができます。</p>
<p>あなたのフリーサイトは50名のアクティブユーザアカウントおよび200MBのディスククオータに制限されています。</p>
<p>ヒント:</p>
<ul>
<li>場所を空けるため、あなたは不要なユーザをサイト管理ページで削除することができます。</li>
<li>コンテンツがあなたのディスククオータに影響することを避けるため、ウェブページ、YouTubeビデオ等のインターネット上のパブリックリソースを使用してください。</li>
</ul>
<p>あなたのディスク使用量を確認するため、いつでもmoodlecloud.comのMoodleCloudポータルにアクセスすることができます。あなたのサイト名「 %subdomain% 」およびあなたのサイト管理者と同じパスワードを使用してログインしてください。</p>

<p>MoodleCloudチーム</p>';
$string['signup:provision_mail.page.plain'] = 'ようこそMoodleCloudへ!
あなたのフリーのMoodleサイト %url% が作成されました。
あなたのMoodleサイトにユーザ名「admin」およびサインアップ時に設定したパスワードを使用してログインすることができます。
あなたのフリーサイトは50名のアクティブユーザアカウントおよび200MBのディスククオータに制限されています。
ヒント:
 - 場所を空けるため、あなたは不要なユーザをサイト管理ページで削除することができます。
 - コンテンツがあなたのディスククオータに影響することを避けるため、ウェブページ、YouTubeビデオ等のインターネット上のパブリックリソースを使用してください。

あなたのディスク使用量を確認するため、いつでもmoodlecloud.comのMoodleCloudポータルにアクセスすることができます。あなたのサイト名「 %subdomain% 」およびあなたのサイト管理者と同じパスワードを使用してログインしてください。

MoodleCloudチーム';
$string['signup:provision_mail.page.title'] = 'あなたのMoodleCloudサイト %fqdn% の準備ができました!';
$string['signup:provision_mail.subject'] = 'あなたのMoodleCloudサイト %site.fqdn% の準備ができました!';
$string['signup:reserve.available'] = 'おめでとうございます! あなたのサイト名を利用できます。';
$string['signup:reserve.form.fields.region'] = 'ホスティングロケーション';
$string['signup:reserve.form.tooltips.region'] = 'これはあなたのサイトが提供される場所です。あなたとあなたの生徒・学生に近い場所の選択をお勧めします。';
$string['signup:status.body.ariasetupcomplete'] = 'あなたの新しいサイトの設定が完了しました。あなたはログインすることができます。';
$string['signup:status.body.lead'] = '<p>Prestoさん!</p>
<p>あなたが望んでいたとおり、あなた専用のMoodleを持つことができました。</p>
<p>中に入って、あなたの完璧なオンライン学習スペースの作成を続けてください。</p>';
$string['signup:status.body.login'] = 'ログイン';
$string['signup:status.body.title'] = 'すべて完了しました! あなた専用のフリーのMoodleサイトです!';
$string['signup:steps.x'] = 'ステップ %x%';
$string['signup:steps.xofy'] = 'ステップ %x% / %y%';
$string['signup:terms.title'] = 'MoodleCloudサイト利用規約';
$string['signup:texts.statusintro'] = 'TODO';
$string['signup:texts.statustitle'] = 'あなたが待ち望んでいたものです。あなた専用のフリーのMoodleサイトです!';
$string['status:label.expired'] = '利用されていないため削除';
$string['status:label.pendingIdentityConfirmation'] = '確認待ち';
$string['status:label.pendingProvision'] = '作成のための待ち行列中';
$string['status:label.pendingRemoval'] = '削除のための待ち行列中';
$string['status:label.provisioned'] = 'ライブ';
$string['status:label.removed'] = '削除済み';
$string['status:label.reserved'] = '予約済み';
$string['status:tooltip.expired'] = '利用されていないため、このサイトは私たちのシステムから削除されました。';
$string['status:tooltip.pendingProvision'] = 'このサイトは私たちのプロビジョニングシステムに送信されました。まもなくあなたの元に戻ります!';
$string['status:tooltip.pendingRemoval'] = 'このサイトは削除のための待ち行列に入れられています。まもなく私たちのシステムから削除されます。';
$string['status:tooltip.provisioned'] = '現在、このサイトは稼動中および利用可能です。';
$string['status:tooltip.removed'] = 'このサイトは削除されました。';
$string['status:tooltip.reserved'] = 'このサイトは予約されていますが、まだサインアップ処理が完了していません。';
$string['telephony:lookup.apifailure'] = '私たちのメッセージングシステムに問題が発生しました。再度お試しください。';
$string['telephony:lookup.invalidnumber'] = '無効な電話番号です。';
$string['telephony:lookup.notacellphone'] = 'あなたは適切な携帯電話番号を提供する必要があります。';
$string['telephony:validator.apifailure'] = '私たちのメッセージングシステムに問題が発生しました。再度お試しください。';
$string['validators:fos_user.current_password.invalid'] = '入力されたパスワードが無効です。';
$string['validators:fos_user.email.already_used'] = 'このメールアドレスはすでに使用されています。';
$string['validators:fos_user.email.blank'] = 'メールアドレスを入力してください。';
$string['validators:fos_user.email.invalid'] = 'メールアドレスが有効ではありません。';
$string['validators:fos_user.email.long'] = 'メールアドレスが長すぎます。';
$string['validators:fos_user.email.short'] = 'メールアドレスが短すぎます。';
$string['validators:fos_user.group.blank'] = '名称を入力してください。';
$string['validators:fos_user.group.long'] = '名称が長すぎます。';
$string['validators:fos_user.group.short'] = '名称が短すぎます。';
$string['validators:fos_user.new_password.blank'] = '新しいパスワードを入力してください。';
$string['validators:fos_user.new_password.short'] = '新しいパスワードが短すぎます。';
$string['validators:fos_user.password.blank'] = 'パスワードを入力してください。';
$string['validators:fos_user.password.mismatch'] = '入力されたパスワードが合致しません。';
$string['validators:fos_user.password.short'] = 'パスワードが短すぎます。';
$string['validators:fos_user.username.already_used'] = 'ユーザ名がすでに使用されています。';
$string['validators:fos_user.username.blank'] = 'ユーザ名を入力してください。';
$string['validators:fos_user.username.long'] = 'ユーザ名が長すぎます。';
$string['validators:fos_user.username.short'] = 'ユーザ名が短すぎます。';
$string['validators:site.subdomain.format'] = 'サブドメインは半角英字で開始してください。これには半角英数字およびハイフンのみ含んでください。';
