<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'ja', branch 'MOODLE_31_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aftercontent'] = 'コンテンツの後';
$string['alert1'] = 'アラート1';
$string['alert2'] = 'アラート2';
$string['alert3'] = 'アラート3';
$string['alert_general'] = 'お知らせ';
$string['alert_info'] = '情報';
$string['alertinfodesc'] = 'あなたのアラートの設定を入力してください。';
$string['alertsdesc'] = 'ここではあなたのユーザに3つの異なるスタイルのアラートをMoodleフロントページで表示します。必要でない場合、忘れずに無効にしてください。';
$string['alertsheading'] = 'ユーザアラート';
$string['alertsheadingsub'] = 'あなたのユーザにフロントページで重要なメッセージを表示する';
$string['alerttext'] = 'アラートテキスト';
$string['alerttextdesc'] = 'あなたのアラートに表示したいテキストです。';
$string['alerttitle'] = 'タイトル';
$string['alerttitledesc'] = 'あなたのアラートのメインタイトル/ヘッディングです。';
$string['alerttype'] = 'レベル';
$string['alerttypedesc'] = 'あなたのユーザに知らせるために最適なアラートレベル/タイプを設定します。';
$string['alert_warning'] = '警告';
$string['allclasses'] = 'すべてのクラス';
$string['allcourses'] = 'すべてのコース';
$string['allmodules'] = 'すべてのモジュール';
$string['allunits'] = 'すべてのユニット';
$string['alternativecolors'] = '代替色 {$a}';
$string['alternativethemecolor'] = '代替テーマ色 {$a}';
$string['alternativethemecolordesc'] = 'あなたのテーマの代替テーマ色 {$a} を設定します。';
$string['alternativethemecolorname'] = '代替テーマ色セット名 {$a}';
$string['alternativethemecolornamedesc'] = 'この代替テーマ色セットに認識可能な名称を提供してください。';
$string['alternativethemecolors'] = '代替テーマ色';
$string['alternativethemecolorsdesc'] = 'ユーザが選択できる代替テーマ色を定義します。';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'デフォルトボタン背景色 {$a}';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'すべてのデフォルトボタン {$a} の背景色を設定します。';
$string['alternativethemedefaultbuttonbackgroundhovercolour'] = 'デフォルトボタン背景ホバー色 {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolourdesc'] = 'すべてのデフォルトボタン {$a} の背景ホバー色を設定します。';
$string['alternativethemedefaultbuttontextcolour'] = 'デフォルトボタンテキスト色 {$a}';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'すべてのデフォルトボタン {$a} のテキスト色を設定します。';
$string['alternativethemedefaultbuttontexthovercolour'] = 'デフォルトボタンホバーテキスト色 {$a}';
$string['alternativethemedefaultbuttontexthovercolourdesc'] = 'すべてのデフォルトボタン {$a} のホバーテキスト色を設定します。';
$string['alternativethemefooterblockbackgroundcolour'] = '代替テーマ色 {$a} のフッタブロック背景色';
$string['alternativethemefooterblockbackgroundcolourdesc'] = '代替テーマ色 {$a} のフッタ内のブロック背景色を設定します。';
$string['alternativethemefooterblockhovercolour'] = '代替テーマ色 {$a} のフッタブロックリンクホバー色';
$string['alternativethemefooterblockhovercolourdesc'] = 'あなたの代替テーマ色 {$a} のフッタ内のリンクブロックテキストにホバーされた時の色設定します。';
$string['alternativethemefooterblocktextcolour'] = '代替テーマ色 {$a} のフッタブロックテキスト色';
$string['alternativethemefooterblocktextcolourdesc'] = 'あなたの代替テーマ色 {$a} のフッタ内のブロックテキスト色を設定します。';
$string['alternativethemefooterblockurlcolour'] = '代替テーマ色 {$a} のフッタブロックリンク色';
$string['alternativethemefooterblockurlcolourdesc'] = 'あなたの代替テーマ色 {$a} のフッタ内のブロックリンクテキスト色を設定します。';
$string['alternativethemefootercolor'] = '代替テーマ色 {$a} のフッタ背景色';
$string['alternativethemefootercolordesc'] = '代替テーマ色 {$a} のフッタボックス背景色を設定します。';
$string['alternativethemefooterheadingcolor'] = '代替テーマ色 {$a} のフッタヘッディング色';
$string['alternativethemefooterheadingcolordesc'] = '代替テーマ色 {$a} のフッタヘッディング色を設定します。';
$string['alternativethemefooterhovercolor'] = '代替テーマ色 {$a} のフッタリンクホバー色';
$string['alternativethemefooterhovercolordesc'] = 'あなたの代替テーマ色 {$a} のリンクブロックテキストにフッタ内でホバーされた時の色を設定します。';
$string['alternativethemefootersepcolor'] = '代替テーマ色 {$a} のフッタセパレータ色';
$string['alternativethemefootersepcolordesc'] = 'セパレータはコンテンツを分離するために使用される線です。ここで代替テーマ色 {$a} の線の色を設定します。';
$string['alternativethemefootertextcolor'] = '代替テーマ色 {$a} のフッタテキスト色';
$string['alternativethemefootertextcolordesc'] = 'あなたの代替テーマ色 {$a} のフッタ内のテキスト色を設定します。';
$string['alternativethemefooterurlcolor'] = '代替テーマ色 {$a} のフッタリンク色';
$string['alternativethemefooterurlcolordesc'] = 'あなたの代替テーマ色 {$a} のフッタ内のリンクテキスト色を設定します。';
$string['alternativethemehovercolor'] = '代替テーマホバー色 {$a}';
$string['alternativethemehovercolordesc'] = 'あなたのテーマホバーの代替テーマ色 {$a} を設定します。';
$string['alternativethemeiconcolor'] = '代替アイコン色 {$a}';
$string['alternativethemeiconcolordesc'] = 'すべてのアイコンの代替 {$a} 色を設定します。';
$string['alternativethemename'] = 'カラースキーマ名';
$string['alternativethemenamedesc'] = 'あなたの代替テーマ色の名称を提供してください。';
$string['alternativethemenavcolor'] = 'ナビゲーションテキスト色 {$a}';
$string['alternativethemenavcolordesc'] = 'ナビゲーションの代替 {$a} テキスト色を設定します。ナビゲーションバーおよびブレッドクラムを装飾的なスタイルにします。';
$string['alternativethemeslidebuttoncolor'] = '代替テーマスライドボタン色 {$a}';
$string['alternativethemeslidebuttoncolordesc'] = 'あなたのテーマスライドボタンの代替テーマ色 {$a} を設定します。';
$string['alternativethemeslidebuttonhovercolor'] = '代替テーマスライドボタンホバー色 {$a}';
$string['alternativethemeslidebuttonhovercolordesc'] = 'あなたのテーマスライドボタンの代替テーマ色 {$a} を設定します。';
$string['alternativethemeslidecaptionbackgroundcolor'] = '代替テーマスライドキャプション背景色 {$a}';
$string['alternativethemeslidecaptionbackgroundcolordesc'] = 'あなたのテーマスライドキャプション背景の代替テーマ色 {$a} を設定します。スライドキャプションオプション「横」には適用されません。';
$string['alternativethemeslidecaptiontextcolor'] = '代替テーマスライドキャプションテキスト色 {$a}';
$string['alternativethemeslidecaptiontextcolordesc'] = 'あなたのテーマスライドキャプションテキストの代替テーマ色 {$a} を設定します。スライドキャプションオプション「横」には適用されません。';
$string['alternativethemeslidecolors'] = '代替テーマスライド色';
$string['alternativethemeslidecolorsdesc'] = 'ユーザが選択できる代替テーマスライド色を定義します。';
$string['alternativethemetextcolor'] = '代替テキスト色 {$a}';
$string['alternativethemetextcolordesc'] = 'あなたの代替テキスト {$a} の色を設定します。';
$string['alternativethemeurlcolor'] = '代替リンク色 {$a}';
$string['alternativethemeurlcolordesc'] = 'あなたの代替リンクテキスト {$a} の色を設定します。';
$string['alwaysdisplay'] = '常に表示する';
$string['analytics'] = '分析';
$string['analyticscleanurl'] = 'クリーンURL';
$string['analyticscleanurldesc'] = '高度なトラッキングのためにクリーンURLを生成します。';
$string['analyticsdesc'] = 'あなたが追加したいアナリティクスのタイプを選択してください。他のオプションを有効にするために保存してください。';
$string['analyticsenabled'] = '有効';
$string['analyticsenableddesc'] = 'Moodle分析を有効にする';
$string['analyticsguniversal'] = 'Googleユニバーサルアナリティクス';
$string['analyticsheadingsub'] = 'Moodleパワフルアナリティクス';
$string['analyticsimagetrack'] = 'イメージトラッキング';
$string['analyticsimagetrackdesc'] = 'Javaスクリプトが無効にされているブラウザのイメージトラッキングを有効にする';
$string['analyticspiwik'] = 'Piwik';
$string['analyticssiteid'] = 'サイトID';
$string['analyticssiteiddesc'] = 'あなたのサイトIIDを入力してください。';
$string['analyticssiteurl'] = 'Analytics URL';
$string['analyticssiteurldesc'] = 'あなたの「Piwikアナリティクス」のURLを「http(s)」および末尾のスラッシュを除いた形で入力してください。例えば次のようになります: mysite.com/analytics';
$string['analyticstrackadmin'] = '管理者トラッキング';
$string['analyticstrackadmindesc'] = '管理者のトラッキングを有効にします (非推奨)。';
$string['analyticstrackingid'] = 'サイトID';
$string['analyticstrackingiddesc'] = 'あなたのトラッキングIDを入力する';
$string['analyticsuseuserid'] = 'ユーザID';
$string['analyticsuseuseriddesc'] = 'ユーザのユーザiDでのトラッキングを有効にします。';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'あなたのGoogle PlayストアのモバイルアプリのURLを提供してください。モバイルアプリのURLを提供できない場合、Moodle公式モバイルアプリのリンクを使用してください (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)。';
$string['androidurl'] = 'Android (Google Play) URL';
$string['asconfigintlower'] = '{$a->value} は下限 {$a->lower} より小さな値です。';
$string['asconfigintupper'] = '{$a->value} は上限 {$a->upper} より大きな値です。';
$string['backtotop'] = 'トップに戻る';
$string['badgepreferences'] = 'バッジ';
$string['beforecontent'] = 'コンテンツの前';
$string['breadcrumbsimple'] = 'Simple';
$string['breadcrumbstyle'] = 'ブレッドクラムスタイル';
$string['breadcrumbstyled'] = 'Fancy';
$string['breadcrumbstyledesc'] = 'ここであなたはブレッドクラムのスタイルを変更することができます。';
$string['breadcrumbstylednocollapse'] = 'Fancy (折り畳みなし)';
$string['breadcrumbthin'] = 'Thin';
$string['cachesused'] = '使用キャッシュ';
$string['categoryctiheading'] = 'カテゴリコースタイトルイメージ';
$string['categoryctiheadingcategory'] = 'カテゴリコースタイトルイメージ: {$a->category}';
$string['categoryctiheadingcs'] = 'カテゴリコースタイトルイメージ設定';
$string['categoryctiinfo'] = '{$a->category} 設定';
$string['categoryctiinfodesc'] = 'カテゴリコースタイトルイメージ設定: {$a->category}';
$string['categoryiconcategory'] = 'カテゴリアイコン: {$a->category}.';
$string['categoryicondesc'] = 'この設定を有効にした場合、あなたはそれぞれのコースカテゴリにアイコンを設定することができます。';
$string['categoryiconheading'] = 'カテゴリアイコン';
$string['categoryiconheadingsub'] = 'あなたのカテゴリを表すアイコンを使用する';
$string['categoryiconinfo'] = 'カスタムカテゴリアイコンを設定する';
$string['categoryiconinfodesc'] = 'あなたが使用したいアイコン名を入力してください。<a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ここで</a>リストを確認することができます。「fa-」以下の文字を入力してください。例 star';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" alt="Essential screen shot"/></p>
</div>
<div class="well">
<h3>About Essential</h3>
<p>Essential is based upon the Bootstrap theme, which was created for Moodle 2.5, with the help of:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Theme Credits</h3>
<p>Original Author: Julian Ridden<br>
Work taken over in July 2014 by:<br>
Gareth J. Barnard<br>
David Bezemer<br>
Work taken over on the 9th October 2014 by:<br>
Gareth J. Barnard<br>
</p>
<h3>Sponsorships</h3>
<p>This theme is provided to you for free, and if you want to express your gratitude for using this theme, please consider sponsoring by:
<h4>PayPal</h4>
<p>Please contact me via my <a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Moodle profile\'</a> for details as I am an individual and therefore am unable to have \'buy me now\' buttons under their terms.</p>
<h4>Flattr</h4>
<a href="https://flattr.com/profile/gjb2048" target="_blank">
click here to sponsor.
</a>
<br>Sponsorships help to facilitate maintenance and allow me to provide you with more and better features. Without your support the theme cannot be maintained.</p>
<p>
<h3>Sponsors</h3>
<p>Sponsorships gratefully received with thanks from:</p>
<ul>
<li>Mihai Bojonca, TCM International Institute.</li>
<li>Guido Hornig, actXcellence <a href="//actxcellence.de" target="_blank">actxcellence.de</a></li>
<li>Delvon Forrester, Esparanza co uk</li>
<li>iZone</li>
<li>Anis Jradah</li>
<li>Ute Hlasek, <a href="//hlasek-it.de/moodle" target="_blank">hlasek-it.de/moodle</a></li>
</ul>
</p>
<p>
<h3>Essential for Moodle 3.0 kindly sponsored by:</h3>
<ul>
<li>Leila Hiret</li>
<li>Vilar da Camara Neto</li>
<li>Kees Koopman</li>
<li>Matej Topolovec</li>
<li>Mihai Bojonca</li>
<li>V. Y. S. Cavalcanti</li>
<li>Christian Kleinhanss</li>
<li>Nadav Kavalerchik</li>
<li>Francisco Gomez Gonzalez</li>
<li>Lazar Ivanov</li>
<li>Duval Arnaud</li>
<li>Kai ner Maa Pitanta</li>
<li>Gregory Reinert</li>
<li>M van der Niet</li>
<li>Floyd Saner</li>
<li>Andreas Schenkel</li>
<li>Gemma Lesterhuis</li>
<li>Roy Bentley</li>
<li>Duane Cox</li>
</ul>
</p>
<h3>Customisation</h3>
<p>If you like this theme and would like me to customise it, transpose functionality to another theme or build a new theme from scratch, then I offer competitive rates. Please contact me via \'www.gjbarnard.co.uk/contact/\' or \'gjbarnard at gmail dot com\' or \'about.me/gjbarnard\' to discuss your requirements.</p>
</div></div>';
$string['colordesc'] = 'ここであなたはこのテーマ内で使用される多くの色を変更することができます。';
$string['colorheading'] = '色';
$string['colorheadingsub'] = 'あなたのテーマで使用する色を設定する';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = '連絡先';
$string['contactinfodesc'] = 'あなたの連絡先を入力してください。';
$string['copyright'] = '著作権';
$string['copyrightdesc'] = 'あなたの組織名です。';
$string['coursecontentsearch'] = 'コースコンテンツ検索';
$string['coursecontentsearchdesc'] = '「ダッシュボード」ページでのコースコンテンツ検索を有効にします。 「$CFG->themedir」内にEssentialがない場合のみ機能します。';
$string['coursegrades'] = 'コース評定';
$string['courselistteachericon'] = 'コース一覧教師アイコン';
$string['courselistteachericondesc'] = 'あなたが使用したいアイコン名を入力してください。<a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ここで</a>リストを確認することができます。「fa-」以下の文字を入力してください。例 star';
$string['credit'] = 'The {$a->name} theme for Moodle is developed by';
$string['customcss'] = 'カスタムCSS';
$string['customcssdesc'] = 'あなたがこのテキストエリアに追加したCSSルールはすべてのページに適用され、このテーマのカスタマイズを容易にします。';
$string['customscrollbars'] = 'カスタムスクロールバー';
$string['customscrollbarsdesc'] = 'カスタムスクロールバーを使用します。これにより標準的なブラウザのスクロールバーが置換されます。';
$string['dbqueries'] = 'DB読み/書き';
$string['dbtime'] = 'DBクエリ時間';
$string['defaultcategoryicon'] = 'デフォルトカテゴリアイコン';
$string['defaultcategoryicondesc'] = 'デフォルトカテゴリアイコンを設定する';
$string['defaultcolors'] = 'デフォルト色';
$string['displayafterlogin'] = 'ログイン後のみに表示する';
$string['displaybeforelogin'] = 'ログイン前のみに表示する';
$string['displayeditingmenu'] = '編集ボタンを表示する';
$string['displayeditingmenudesc'] = 'デフォルトページ編集ボタンと同じ機能のボタンをヘッダに表示します。';
$string['displayhiddenmycourses'] = '非表示コースを表示する';
$string['displayhiddenmycoursesdesc'] = 'ユーザに非表示コースを閲覧するパーミッションがある場合、「コースメニュー」に非表示コースを表示します。';
$string['displaymycourses'] = 'コースを表示する';
$string['displaymycoursesdesc'] = '「ナビゲーションバー」内にユーザの登録済みコースを表示します。';
$string['dontdisplay'] = '表示しない';
$string['editingmenu'] = 'ページ編集スイッチ';
$string['editingmenudesc'] = 'ユーザがページを編集できる場合、現在のページの編集をON/OFFにスイッチできるボタンを表示します。これは通常のページ編集ボタンと同じ機能です。';
$string['enablealert'] = 'アラートを有効にする';
$string['enablealertdesc'] = 'アラートを有効または無効にする';
$string['enablealternativethemecolors'] = '代替テーマ色 {$a} を有効にする';
$string['enablealternativethemecolorsdesc'] = 'この設定を有効にした場合、ユーザは代替テーマ色 {$a} を選択することができます。';
$string['enablecategorycti'] = 'カテゴリコースタイトルイメージを有効にする';
$string['enablecategoryicon'] = 'カテゴリアイコンを有効にする';
$string['enablecategoryicondesc'] = 'この設定を有効にした場合、あなたは「変更を保存する」ボタンをクリックした後にカテゴリアイコンを選択することができるようになります。';
$string['enablecustomcategoryicon'] = 'カスタムカテゴリアイコンを有効にする';
$string['enablecustomcategoryicondesc'] = 'この設定を有効にした場合、このセクションの下にカテゴリおよびカスタマイズ可能なオプションが表示されます。この設定を有効または無効にした後、変更を保存してください。';
$string['extperfinfoheading'] = '拡張パフォーマンス情報';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'あなたのFacebookページのURLを入力してください (例 https://www.facebook.com/mycollege)。';
$string['facebookurl'] = 'Facebook URL';
$string['favicon'] = 'カスタムファビコン';
$string['favicondesc'] = 'あなたのファビコンをアップロードしてください。.icoファイルにしてください。';
$string['featuredesc'] = 'ここであなたはこのテーマの多くの機能設定を変更することができます。';
$string['featureheading'] = '機能';
$string['featureheadingsub'] = 'あなたのテーマで使用する機能を設定する';
$string['few'] = '数';
$string['findcoursecontent'] = 'コースコンテンツ:';
$string['fitvids'] = 'FitVidsを使用する';
$string['fitvidsdesc'] = 'あなたの埋め込みビデオをレスポンシブにするためにFitVids (fitvidsjs.com) を有効にします。FitVidsが有効にされて、あなたがビデオを除外したい場合、エディタのHTMLモードで「iframe」タグに「class="fitvidsignore"」を追加してください。例えば次のようになります: <iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe>';
$string['fixedwidthnarrow'] = '固定幅 - 狭い';
$string['fixedwidthnormal'] = '固定幅 - 通常';
$string['fixedwidthwide'] = '固定幅 - 広い';
$string['flattr_click'] = 'Flattr経由で出資';
$string['flattr_desc'] = '{$a->url}';
$string['flickr'] = 'Flickr';
$string['flickrdesc'] = 'あなたのFlickrページのURLを入力してください (例 http://www.flickr.com/photos/mycollege)。';
$string['flickrurl'] = 'Flickr URL';
$string['floatingsubmitbuttons'] = 'フローティング送信ボタン';
$string['floatingsubmitbuttonsdesc'] = 'デスクトップデバイスでフォームを送信するときに使用されるボタンを含む「フローティング」エリアを表示します。これはページのスクロールを減らします。コース登録またはフォーム投稿には使用されません。';
$string['fontcharacterset'] = 'Googleフォント追加文字セット';
$string['fontcharactersetcyrillic'] = 'キリル文字';
$string['fontcharactersetcyrillicext'] = 'キリル文字拡張';
$string['fontcharactersetdesc'] = '異なる言語の追加文字設定を選択してください。多くの文字セットを使用することであなたのMoodleがスローダウンする可能性があります。そのため、本当に必要な文字セットのみ選択してください。';
$string['fontcharactersetgreek'] = 'ギリシア文字';
$string['fontcharactersetgreekext'] = 'ギリシア文字拡張';
$string['fontcharactersetlatinext'] = 'ラテン文字拡張';
$string['fontcharactersetvietnamese'] = 'ベトナム文字';
$string['fontfileeotbody'] = 'ボディEOTフォントファイル';
$string['fontfileeotheading'] = 'ヘッディングEOTフォントファイル';
$string['fontfileotfbody'] = 'ボディOTFフォントファイル';
$string['fontfileotfheading'] = 'ヘッディングOTFフォントファイル';
$string['fontfiles'] = 'フォントファイル';
$string['fontfilesdesc'] = 'ここであなたのフォントファイルをアップロードしてください。';
$string['fontfilesvgbody'] = 'ボディSVGフォントファイル';
$string['fontfilesvgheading'] = 'ヘッディングSVGフォントファイル';
$string['fontfilettfbody'] = 'ボディTTF フォントファイル';
$string['fontfilettfheading'] = 'ヘッディングTTF フォントファイル';
$string['fontfilewoffbody'] = 'ボディWOFFフォントファイル';
$string['fontfilewoffheading'] = 'ヘッディングWOFFフォントファイル';
$string['fontfilewofftwobody'] = 'ボディWOFF2フォントファイル';
$string['fontfilewofftwoheading'] = 'ヘッディングWOFF2フォントファイル';
$string['fontheadingdesc'] = 'あなたのMoodle環境で使用したいフォントを選択および入力してください。';
$string['fontheadingsub'] = 'フォント設定';
$string['fontnamebody'] = 'テキストフォント';
$string['fontnamebodydesc'] = '他のすべてのテキストで使用されるフォントの正確な名称を入力してください。';
$string['fontnameheading'] = 'ヘッディングフォント';
$string['fontnameheadingdesc'] = 'ヘッディングで使用されるフォントの正確な名称を入力してください。';
$string['fontselect'] = 'フォントタイプセレクタ';
$string['fontselectdesc'] = '利用可能なフォントタイプをリストから選択してください。あなたの選択を適用するために保存してください。';
$string['fontsettings'] = 'フォント';
$string['fonttypecustom'] = 'カスタムフォント';
$string['fonttypegoogle'] = 'Googleウェブフォント';
$string['fonttypeuser'] = 'ユーザフォント';
$string['footerblockbackgroundcolour'] = 'フッタブロック背景色';
$string['footerblockbackgroundcolourdesc'] = 'フッタのブロック背景色を設定します。';
$string['footerblockhovercolour'] = 'フッタブロックリンクホバー色';
$string['footerblockhovercolourdesc'] = 'あなたのリンクブロックテキストにフッタ内でホバーされた時の色を設定します。';
$string['footerblocktextcolour'] = 'フッタブロックテキスト色';
$string['footerblocktextcolourdesc'] = 'あなたのフッタ内でのブロックテキスト色を設定します。';
$string['footerblockurlcolour'] = 'フッタブロックリンク色';
$string['footerblockurlcolourdesc'] = 'あなたのフッタ内でのリンクブロックテキスト色を設定します。';
$string['footercolor'] = 'フッタ背景色';
$string['footercolordesc'] = 'フッタボックスの背景色を設定します。';
$string['footercolors'] = 'フッタ色';
$string['footercolorsdesc'] = 'ページフッタの色を変更します。';
$string['footerheading'] = 'フッタ';
$string['footerheadingcolor'] = 'フッタヘッディング色';
$string['footerheadingcolordesc'] = 'フッタのヘッディング色を設定します。';
$string['footerhovercolor'] = 'フッタリンクホバー色';
$string['footerhovercolordesc'] = 'あなたのリンクテキストにフッタ内でホバーされた時の色を設定します。';
$string['footersepcolor'] = 'フッタセパレータ色';
$string['footersepcolordesc'] = 'セパレータはコンテンツを分離するために使用される線です。ここで線の色を設定します。';
$string['footertextcolor'] = 'フッタテキスト色';
$string['footertextcolordesc'] = 'あなたのフッタ内でのテキスト色を設定します。';
$string['footerurlcolor'] = 'フッタリンク色';
$string['footerurlcolordesc'] = 'あなたのフッタ内でのリンクテキスト色を設定します。';
$string['footnote'] = 'フットノート';
$string['footnotedesc'] = 'このテキストエリアに入力した内容はあなたのMoodleサイトすべてのフッタに表示されます。';
$string['fppagetopblocks'] = '追加フロントページ「ページトップ」ブロックを有効にする';
$string['frontcontent'] = 'フロントページコンテンツエリアを有効にする';
$string['frontcontentarea'] = 'フロントページコンテンツエリアコンテンツ';
$string['frontcontentareadesc'] = 'このボックスに入力した内容はスライドショーとマーケティングボックスの間にページの全幅に表示されます。';
$string['frontcontentdesc'] = 'この設定を有効にした場合、あなたのカスタムコンテンツのためのカスタムコンテンツエリアをスライドショーとマーケティングボックスの間に追加します。';
$string['frontcontentheading'] = 'フロントページコンテンツエリア';
$string['frontpageblocks'] = 'フロントページブロック配置';
$string['frontpageblocksheading'] = 'フロントページブロック';
$string['frontpageheading'] = 'フロントページ';
$string['frontpageheadingdesc'] = 'あなたがフロントページに表示したい追加アイテムをここで設定します。';
$string['frontpagemiddleblocks'] = '追加フロントページ「ホーム」ブロックを有効にする';
$string['frontpagemiddleblocksdesc'] = 'この設定を有効にした場合、追加ブロックロケーションをマーケティングスポットの下に表示します。';
$string['fullname'] = 'サイトフルネーム';
$string['fullnamesummary'] = 'フルネームおよび概要';
$string['generalheadingdesc'] = 'ここでテーマの一般設定を設定します。';
$string['generalheadingsub'] = '一般設定';
$string['genericsettings'] = '一般';
$string['googleplus'] = 'Google+';
$string['googleplusdesc'] = 'あなたのGoogle+プロファイルのURLを入力してください (例 https://plus.google.com/+mycollege)。';
$string['googleplusurl'] = 'Google+ URL';
$string['gotobottom'] = 'ページ最下部に移動する';
$string['headerbackground'] = 'ヘッダ背景イメージ';
$string['headerbackgrounddesc'] = 'あなたの背景イメージをアップロードしてください。';
$string['headerbackgroundstyle'] = 'ヘッダ背景スタイル';
$string['headerheading'] = 'ヘッダ';
$string['headertextcolor'] = 'ヘッダテキスト色';
$string['headertextcolordesc'] = 'ヘッダのテキスト色を設定します。';
$string['headertitle'] = 'ヘッダタイトル';
$string['headertitledesc'] = 'ヘッダに表示されるタイトルを設定してください。注意: ヘッダタイトルはロゴがない場合のみ使用されます。';
$string['helplink'] = 'ヘルプリンク';
$string['helplinkdesc'] = 'あなたが上でURLを選択した場合、あなたのヘルプサイトの完全なURLを入力してください (http:// または https:// を含んでください)。あなたがメールアドレスを選択した場合、あなたのメールアドレスを入力してください。';
$string['helplinktype'] = 'メニューのヘルプリンクを有効にする';
$string['helplinktypedesc'] = 'ユーザメニューのヘルプオプションを有効にするかどうか選択してください。あなたは新しいウィンドウで開くURLまたはメールアドレスを選択することができます。';
$string['hidedefaulteditingbutton'] = 'デフォルトのページ編集ボタンを隠す';
$string['hidedefaulteditingbuttondesc'] = 'すべてのページからデフォルトのページ編集ボタンを隠します。この設定は「ページ編集ボタンを表示する」設定が有効にされている場合のみ影響します。';
$string['hideonphone'] = 'モバイルでスライドショーを隠す';
$string['hideonphonedesc'] = 'あなたがモバイルでスライドショーを無効にしたい場合、選択してください。';
$string['hideontablet'] = 'タブレットでスライドショーを隠す';
$string['hideontabletdesc'] = 'あなたがタブレットでスライドショーを無効にしたい場合、選択してください。';
$string['included'] = '含まれるファイル';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'あなたのInstagramページのURLを入力してください (例 http://instagram.com/mycollege)。';
$string['instagramurl'] = 'Instagram URL';
$string['ios'] = 'iPhone/iPad (Appストア)';
$string['iosdesc'] = 'あなたのAppストアのモバイルアプリのURLを提供してください。モバイルアプリのURLを提供できない場合、Moodle公式モバイルアプリのリンクを使用してください  (https://itunes.apple.com/en/app/moodle-mobile/id633359593)。';
$string['iosicon'] = 'iOSホームスクリーンアイコン';
$string['iosicondesc'] = 'このテーマではiOSおよびAndroidホームスクリーンのデフォルトアイコンを提供しません。必要であれば、あなたのカスタムアイコンをアップロードすることができます。';
$string['iosurl'] = 'iPhone/iPad (Appストア) URL';
$string['ipadicon'] = 'iPadアイコン (非Retina)';
$string['ipadicondesc'] = 'アイコンは72px x 72pxのPNGファイルにしてください。';
$string['ipadretinaicon'] = 'iPadアイコン (Retina)';
$string['ipadretinaicondesc'] = 'アイコンは144px x 144px のPNGファイルにしてください。';
$string['iphoneicon'] = 'iPhone/iPod Touchアイコン (非Retina)';
$string['iphoneicondesc'] = 'アイコンは57px x 57pxのPNGファイルにしてください。';
$string['iphoneretinaicon'] = 'iPhone/iPod Touchアイコン (Retina)';
$string['iphoneretinaicondesc'] = 'アイコンは114px x 114pxのPNGファイルにしてください。';
$string['layout'] = '標準コースレイアウトを使用する';
$string['layoutdesc'] = 'このテーマは両サイドにブロックカラムを配置するよう設計されています。標準的なMoodleコースレイアウトを希望する場合、あなたはこの設定を有効にして古い3カラムレイアウトに戻ることができます。';
$string['left'] = '左';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'あなたのLinkedInプロファイルのURLを入力してください (例 https://www.linkedin.com/company/mycollege)。';
$string['linkedinurl'] = 'LinkedIn URL';
$string['loadtime'] = '読み込み時間';
$string['loggedinas'] = '代替ログイン';
$string['loggedinfrom'] = 'ログイン元';
$string['loginbackground'] = 'ログイン背景イメージ';
$string['loginbackgroundstyle'] = 'ログイン背景スタイル';
$string['loginbackgroundstyledesc'] = 'アップロードされたイメージのスタイルを選択してください。';
$string['logo'] = 'ロゴ';
$string['logodesc'] = 'あなたのカスタムロゴをヘッダに追加したい場合、ここでアップロードしてください。
<br />
イメージはロゴの高さ設定と同じ高さにしてください。また、適切な幅にしてください。
<br />
あなたがロゴをアップロードした場合、デフォルトで表示される標準アイコンおよび名称と置換されます。';
$string['logoheight'] = 'ロゴ高さ';
$string['logoheightdesc'] = 'ロゴイメージの高さです。これはpxまたはemで設定することができます。';
$string['logowidth'] = 'ロゴ幅';
$string['logowidthdesc'] = 'ロゴイメージの幅です。これはpxまたはemで設定することができます。';
$string['marketing1'] = 'マーケティングスポット1';
$string['marketing2'] = 'マーケティングスポット2';
$string['marketing3'] = 'マーケティングスポット3';
$string['marketingbuttontext'] = 'リンクテキスト';
$string['marketingbuttontextdesc'] = 'ボタンに表示されるテキストです。';
$string['marketingbuttonurl'] = 'リンクURL';
$string['marketingbuttonurldesc'] = 'ボタンがリンクするURLです。';
$string['marketingcontent'] = 'コンテンツ';
$string['marketingcontentdesc'] = 'マーケティングボックスに表示されるコンテンツです。簡潔に記載してください。';
$string['marketingdesc'] = 'このテーマではスライドショーの下に3つの「マーケティング」または「広告」を有効にするオプションを提供します。これによりコアな情報を容易に確認して、あなたのユーザへのダイレクトリンクを提供することができます。';
$string['marketingheading'] = 'マーケティングスポット';
$string['marketingheadingsub'] = 'フロントページに情報およびリンクを追加する3つの場所です。';
$string['marketingheight'] = 'マーケティングスポットコンテナの高さ (px)';
$string['marketingheightdesc'] = 'マーケティングスポットコンテナの高さ (ピクセル) を指定してください。あなたのコンテンツに適するよう調整してください。スポット内にイメージまたはリンクがある場合、すべてのスポットにおいてこの値に追加されます。';
$string['marketingicon'] = 'アイコン';
$string['marketingicondesc'] = 'あなたが使用したいアイコン名を入力してください。<a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ここで</a>リストを確認することができます。「fa-」以下の文字を入力してください。例 star';
$string['marketingimage'] = 'イメージ';
$string['marketingimagedesc'] = 'ここではマーケティングスポット上部にイメージを表示するオプションを提供します。';
$string['marketingimageheight'] = 'マーケティングイメージの高さ (px)';
$string['marketingimageheightdesc'] = 'マーケティングボックスにイメージを表示したい場合、あなたはここで高さ (ピクセル) を指定することができます。';
$string['marketinginfodesc'] = 'あなたのマーケティングスポットの設定を入力してください。';
$string['marketingtitle'] = 'タイトル';
$string['marketingtitledesc'] = 'このマーケティングスポットに表示するタイトルです。';
$string['marketingurltarget'] = 'リンクターゲット';
$string['marketingurltargetdesc'] = 'リンクをどのように開くか選択してください。';
$string['marketingurltargetnew'] = '新しいページ';
$string['marketingurltargetparent'] = '親フレーム';
$string['marketingurltargetself'] = '現在のページ';
$string['memused'] = '使用メモリ';
$string['mobileappsdesc'] = 'AppストアまたはGoogle Playストアでウェブアプリを取得しましたか? あなたのユーザがアプリをオンラインで取得できるよう、ここでリンクを提供してください。';
$string['mobileappsheading'] = 'Apps';
$string['mobileappsheadingsub'] = 'あなたの学生がモバイルで使用するためのアプリにリンクする';
$string['myclasses'] = 'マイクラス';
$string['mycourses'] = 'マイコース';
$string['mycoursesinfo'] = 'コースメニュー';
$string['mycoursesinfodesc'] = 'ユーザに登録済みコース一覧を動的に表示します';
$string['mycoursesorder'] = 'コース順';
$string['mycoursesorderid'] = 'コースID';
$string['mycoursesorderidasc'] = '昇順';
$string['mycoursesorderiddes'] = '降順';
$string['mycoursesorderidorder'] = 'コースID順';
$string['mycoursesordersort'] = 'コース並べ替え順';
$string['mycoursetitle'] = '用語';
$string['mycoursetitledesc'] = 'ドロップダウンメニューの「マイコース」リンクの用語を変更します。';
$string['mygrades'] = 'マイ評定';
$string['mymodules'] = 'マイモジュール';
$string['myunits'] = 'マイユニット';
$string['navbartitle'] = 'ナビゲーションバータイトル';
$string['navbartitledesc'] = 'ここではナビゲーションに表示されるタイトルを設定します。';
$string['nextsection'] = '次のセクション';
$string['nobreadcrumb'] = '非表示';
$string['noenrolments'] = 'あなたの現在の登録はありません。';
$string['nomessagesfound'] = 'メッセージは見つかりませんでした。';
$string['noslidetitle'] = 'スライドタイトルなし {$a->slide}';
$string['notitle'] = 'タイトルなし';
$string['numberofcoursesandsubcatcourses'] = 'コース数 - サブカテゴリコース';
$string['numberofslides'] = 'スライド数';
$string['numberofslides_desc'] = 'スライダのスライド数です。';
$string['oldnavbar'] = '古いナビゲーションバーのポジションを使用する';
$string['oldnavbardesc'] = '古いナビゲーションバーのポジションを使用する場合、このオプションを有効にしてください。ナビゲーションバーをヘッダの下に置きます。';
$string['pagebackground'] = 'ページ背景イメージ';
$string['pagebackgrounddesc'] = 'あなたの背景イメージをアップロードしてください。以下でイメージのスタイルを選択してください。';
$string['pagebackgroundstyle'] = 'ページ背景スタイル';
$string['pagebackgroundstyledesc'] = 'アップロードされたイメージのスタイルを選択してください。';
$string['pagewidth'] = 'ページ幅を設定する';
$string['pagewidthdesc'] = 'あなたのサイトに利用できるページ幅をリストから選択してください。';
$string['paypal_click'] = 'Moodleプロファイル';
$string['paypal_desc'] = 'よろしければ、私の {$a->url} の詳細をご覧になり、PayPal経由での出資をお考えください。または必要な開発を継続させるために、あなたの気持ちを伝えるために';
$string['peakmem'] = '最大メモリ';
$string['people'] = '人';
$string['perfinfo'] = 'パフォーマンス情報モード';
$string['perfinfodesc'] = '多くのサイトでは詳細なパフォーマンス情報を必要としません。特にユーザが閲覧する場合です。この設定を有効にした場合、不要な情報を取り除いた最小限の形で基本的なページ読み込み情報が表示されます。';
$string['perfinfoheading'] = 'パフォーマンス情報';
$string['perf_max'] = '詳細';
$string['perf_min'] = '最小';
$string['pinterest'] = 'Pinterest';
$string['pinterestdesc'] = 'あなたのPinterestページのURLを入力してください (例 http://pinterest.com/mycollege/mypinboard)。';
$string['pinteresturl'] = 'Pinterest URL';
$string['pluginname'] = 'Essential';
$string['previoussection'] = '前のセクション';
$string['profilebarcustomtitle'] = 'プロファイルバーカスタムブロックタイトル';
$string['profilebarcustomtitledesc'] = 'カスタムプロファイルバーブロックのタイトルです。';
$string['readme_click'] = 'README.txtファイルを読むにはここをクリックしてください。';
$string['readme_desc'] = '{$a->url} Essentialテーマのカスタマイズを含む詳細情報を含みます。';
$string['readme_title'] = 'Essential read-me';
$string['readmore'] = '詳細';
$string['region-footer-left'] = 'フッタ (左)';
$string['region-footer-middle'] = 'フッタ (中央)';
$string['region-footer-right'] = 'フッタ (右)';
$string['region-hidden-dock'] = 'ユーザから隠す';
$string['region-home'] = 'ホーム';
$string['region-page-top'] = 'ページトップ';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
$string['returntosection'] = '{$a->section} に戻る';
$string['returntosectionfeature'] = 'セクションに戻る';
$string['returntosectionfeaturedesc'] = 'コースモジュール内でセクションに戻る機能を有効にします。';
$string['returntosectiontextlimitfeature'] = 'セクションに戻るテキスト制限';
$string['returntosectiontextlimitfeaturedesc'] = 'ボタンのセクション名の長さを {$a->lower} から {$a->upper} 文字に制限します。';
$string['right'] = '右';
$string['serverload'] = 'サーバ負荷';
$string['sessionsize'] = 'セッションサイズ';
$string['shortname'] = 'サイト省略名';
$string['shortnamesummary'] = '省略名および概要';
$string['siteicon'] = 'サイトアイコン';
$string['siteicondesc'] = 'あなたが使用したいアイコン名を入力してください。<a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ここで</a>リストを確認することができます。「fa-」以下の文字を入力してください。例 star';
$string['skype'] = 'Skypeアカウント';
$string['skypedesc'] = 'あなたの組織のSkypeアカウントのSkypeユーザ名のURLを入力してください (例 skype://my.college)。';
$string['skypeuri'] = 'SkypeアカウントURI';
$string['slidebuttoncolor'] = 'スライドボタン色';
$string['slidebuttoncolordesc'] = 'スライドナビゲーションボタンの色です。';
$string['slidebuttonhovercolor'] = 'スライドボタンホバー色';
$string['slidebuttonhovercolordesc'] = 'スライドナビゲーションボタンのホバー色です。';
$string['slidecaption'] = 'スライドキャプション';
$string['slidecaptionbackgroundcolor'] = 'スライドキャプション背景色';
$string['slidecaptionbackgroundcolordesc'] = 'スライドキャプションの背景色を設定します。スライドキャプションオプション「横」には適用されません。';
$string['slidecaptionbelow'] = 'スライドキャプションイメージ下部';
$string['slidecaptionbelowdesc'] = 'スライドキャプションをイメージの下に置きたい場合、この設定を有効にしてください。';
$string['slidecaptionbeside'] = '横';
$string['slidecaptioncentred'] = 'スライドキャプション中央';
$string['slidecaptioncentreddesc'] = 'スライドキャプションを中央に置きたい場合、この設定を有効にしてください。';
$string['slidecaptiondesc'] = 'スライドで使用するキャプションテキストを入力してください。';
$string['slidecaptionontop'] = '上部';
$string['slidecaptionoptions'] = 'スライドキャプションオプション';
$string['slidecaptionoptionsdesc'] = 'イメージに関するキャプションを表示する場所です。';
$string['slidecaptiontextcolor'] = 'スライドキャプションテキスト色';
$string['slidecaptiontextcolordesc'] = 'スライドキャプションテキストの色です。スライドキャプションオプション「横」には適用されません。';
$string['slidecaptionunderneath'] = '下部';
$string['slidecolor'] = 'スライドテキスト色';
$string['slidecolordesc'] = 'スライドキャプションテキストの色です。';
$string['slideimage'] = 'スライドイメージ';
$string['slideimagedesc'] = '画像が透過されている場合、最適に動作します。';
$string['slideinterval'] = 'スライドインターバル';
$string['slideintervaldesc'] = 'スライドの切り替え間隔をミリ秒で設定してください。';
$string['slideno'] = 'スライド {$a->slide}';
$string['slidenodesc'] = 'スライド {$a->slide} の設定を入力してください。';
$string['slideshowdesc'] = 'ここではあなたのサイトに重要情報を宣伝するため、最大16スライドの動的なスライドショーを作成します。スライドショーはレスポンシブであり画面サイズに合わせてイメージの高さが設定されます。推奨の高さは300pxです。幅が100%にされるため画面サイズより幅が大きい場合、実際の高さは小さくなります。画面サイズが小さい場合、別のイメージを提供する必要なしに高さが動的に減らされます。参考までに「画面幅 < 767px = 高さ165px、画面幅 768px ～ 979px = 高さ 225px、画面幅 > 980px = 高さ 300px」となります。スライドのイメージが選択されない場合、pixフォルダ内のdefault_slideイメージが使用されます。';
$string['slideshowheading'] = 'スライドショー';
$string['slideshowheadingsub'] = 'フロントページのダイナミックスライドショー';
$string['slidetitle'] = 'スライドタイトル';
$string['slidetitledesc'] = 'あなたのスライドの説明的なタイトルを入力してください。';
$string['slideurl'] = 'スライドリンク';
$string['slideurldesc'] = 'スライドイメージリンクのリンク先を入力してください。';
$string['slideurltarget'] = 'リンクターゲット';
$string['slideurltargetdesc'] = 'リンクをどのように開くか選択してください。';
$string['slideurltargetnew'] = '新しいページ';
$string['slideurltargetparent'] = '親フレーム';
$string['slideurltargetself'] = '現在のページ';
$string['socialdesc'] = 'あなたのブランドを宣伝するためのソーシャルネットワークの直リンクを提供してください。これはすべてのページのヘッダに表示されます。';
$string['socialheading'] = 'ソーシャルネットワーキング';
$string['socialheadingsub'] = 'あなたのユーザをソーシャルネットワーキングと関連付ける';
$string['socialnetworks'] = 'ソーシャルネットワーク';
$string['sponsor_desc'] = '私は個人の開発者であるため、「buy me now」ボタンを設置することができません。';
$string['sponsor_desc2'] = 'もお考えください。';
$string['sponsor_title'] = 'Essentialのスポンサーになる';
$string['styleguide'] = 'スタイルガイド';
$string['styleguidedesc'] = 'オリジナルドキュメンテーションコードは「 {$a->origcodelicenseurl} 」にライセンスされています。Holder.jsは「 {$a->holderlicenseurl} 」にライセンスされています。追加コードは「 {$a->thiscodelicenseurl} 」にライセンスされています。これは「 {$a->compatible} 」ライセンスです。コンテンツは「 {$a->contentlicenseurl} 」にライセンスされています。ドキュメンテーションはMoodleでの出力用に適切なFontAwesomeアイコンを使用して書式を整えています。追加CSSはessential_admin_setting_styleguide.phpファイル内のコメント「// Beyond docs.css.」の下にあります。「 {$a->globalsettings} 」セクションは削除されました。';
$string['styleguidesub'] = 'Bootstrap V2.3.2スタイルガイド';
$string['themecolor'] = 'テーマ色';
$string['themecolordesc'] = 'あなたのテーマ色を設定します。あなたがMoodleサイト全体で表示したい色のために複数の構成要素が変更されます。';
$string['themecolors'] = 'テーマ色';
$string['themedefaultbuttonbackgroundcolour'] = 'デフォルトボタン背景色';
$string['themedefaultbuttonbackgroundcolourdesc'] = 'すべてのデフォルトボタンの背景色を設定します。';
$string['themedefaultbuttonbackgroundhovercolour'] = 'デフォルトボタン背景ホバー色';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = 'すべてのデフォルトボタンの背景ホバー色を設定します。';
$string['themedefaultbuttontextcolour'] = 'デフォルトボタンテキスト色';
$string['themedefaultbuttontextcolourdesc'] = 'すべてのデフォルトボタンのテキスト色を設定します。';
$string['themedefaultbuttontexthovercolour'] = 'デフォルトボタンテキストホバー色';
$string['themedefaultbuttontexthovercolourdesc'] = 'すべてのデフォルトボタンのテキストホバー色を設定します。';
$string['themehovercolor'] = 'テーマホバー色';
$string['themehovercolordesc'] = 'あなたのテーマのホバー色を設定します。これはリンク、メニュー等に使用されます。';
$string['themeiconcolor'] = 'アイコン色';
$string['themeiconcolordesc'] = 'すべてのアイコン色を設定します。';
$string['themenavcolor'] = 'ナビゲーションテキスト色';
$string['themenavcolordesc'] = 'ナビゲーションのテキスト色を設定します。ナビゲーションバーおよびブレッドクラムを装飾的なスタイルにします。';
$string['themetextcolor'] = 'テキスト色';
$string['themetextcolordesc'] = 'あなたのテキスト色を設定します。';
$string['themeurlcolor'] = 'リンク色';
$string['themeurlcolordesc'] = 'あなたのリンクテキスト色を設定します。';
$string['thiscourse'] = 'このコース';
$string['togglemarketing'] = 'マーケティングスポット表示スイッチ';
$string['togglemarketingdesc'] = 'あなたが希望するマーケティングスポットの表示または非表示を選択してください。';
$string['toggleslideshow'] = 'スライドショー表示スイッチ';
$string['toggleslideshowdesc'] = 'あなたが希望するスライドショーの表示・非表示を選択してください。';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'あなたのTwitterフィードのURLを入力してください (例 https://www.twitter.com/mycollege)。';
$string['twitterurl'] = 'Twitter URL';
$string['unreadnewnotification'] = '新しい通知';
$string['usecategoryicon'] = 'カテゴリアイコンを有効にする';
$string['usecategoryicondesc'] = 'カテゴリにカスタムアイコンを使用する';
$string['usermenu'] = 'ユーザメニュー';
$string['usermenudesc'] = 'ユーザのメニューです。';
$string['usesiteicon'] = 'サイトアイコンを使用する';
$string['variablewidth'] = '可変幅';
$string['versionalerttext1'] = 'テーマはMoodleのバージョンのために設計されていません。';
$string['versionalerttext2'] = '予期しない問題が発生しました。あなたのMoodleのバージョンに適合する正しいバージョンを使用してください。';
$string['versionalerttitle'] = 'バージョン警告:';
$string['visibleadminonly'] = '以下のエリアに移動されたブロックは管理者のみ閲覧することができます。';
$string['vk'] = 'VKontakte';
$string['vkdesc'] = 'あなたのVkontakteページのURLを入力してください (例 http://www.vk.com/mycollege)。';
$string['vkurl'] = 'VKontakte URL';
$string['website'] = 'ウェブサイト';
$string['websitedesc'] = 'あなたのウェブサイトのURLを入力してください (例 http://about.me/gjbarnard)。';
$string['websiteurl'] = 'ウェブサイトURL';
$string['windows'] = 'Windowsデスクトップ';
$string['windowsdesc'] = 'あなたのWindowsストアのモバイルアプリのURLを提供してください。モバイルアプリのURLを提供できない場合、Moodle公式モバイルアプリのリンクを使用してください (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)。';
$string['windowsurl'] = 'WindowsデスクトップURL';
$string['winphone'] = 'Windowsモバイル';
$string['winphonedesc'] = 'あなたのWindows PhoneストアのモバイルアプリのURLを提供してください。モバイルアプリのURLを提供できない場合、Moodle公式モバイルアプリのリンクを使用してください (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)。';
$string['winphoneurl'] = 'WindowsモバイルURL';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'あなたのYouTubeチャンネルのURLを入力してください (例 https://www.youtube.com/user/mycollege)。';
$string['youtubeurl'] = 'YouTube URL';
